% Generated by roxygen2 (4.0.1): do not edit by hand
\name{complmrob}
\alias{complmrob}
\title{MM-type estimators for linear regression on compositional data}
\usage{
complmrob(formula, data)
}
\arguments{
\item{formula}{The formula for the regression model}

\item{data}{The data.frame to use}
}
\value{
A list of type \code{complmrob} with fields
     \describe{
         \item{coefficients}{the estimated coefficients}
         \item{models}{the single regression models (one for each orthonormal basis)}
         \item{npred}{the number of predictor variables}
         \item{predictors}{the names of the predictor variables}
         \item{coefind}{the index of the relevent coefficient in the single regression models}
         \item{call}{how the function was called}
         \item{intercept}{if an intercept is included}
     }
}
\description{
Uses the \code{\link[robustbase]{lmrob}} method for robust linear regression models to fit
a linear regression models to compositional data.
}
\details{
The variables on the right-hand-side of the formula will be transformed with the isometric log-ratio
transformation (\code{\link{isomLR}}) and then the robust linear regression model is applied to
those transformed variables. The orthonormal basis can be constructed in \code{p} different ways,
where \code{p} is the number of variables on the RHS of the formula.

To get an interpretable estimate of the regression coefficient for each part of the composition,
the data has to be transformed according to each of these orthonormal basis and a regression model
has to be fit to every transformed data set.
}
\examples{
\donttest{
library(robCompositions)
data(expendituresEU)
data <- data.frame(y = as.numeric(apply(expendituresEU , 1, sum)), expendituresEU)

compModel <- complmrob(y ~ ., data = data)
summary(compModel)
}
}
\references{
K. Hron, P. Filzmoser & K. Thompson (2012): Linear regression with compositional explanatory
     variables, Journal of Applied Statistics, DOI:10.1080/02664763.2011.644268
}

