% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldComradesMethodsAndHelpers.R
\docType{methods}
\name{plotStructure}
\alias{plotStructure}
\alias{plotStructure,comradesDataSet-method}
\title{plotStructure}
\usage{
plotStructure(foldedCds, rnaRefs, s = "s1", n = 1)
}
\arguments{
\item{foldedCds}{\code{comradesDataSet} after running foldComrades}

\item{rnaRefs}{A fasta of the transcript (made with seqinr::read.fasta)}

\item{s}{sample of structure}

\item{n}{number of structure}
}
\value{
a diagram of the predicted structure
}
\description{
This method plots a structures chosen from the
plotEnsemblePCA method
}
\examples{
\dontrun{
cds = makeExampleComradesDataSet()
clusteredCds = clusterComrades(cds = cds,
                               cores = 3,
                               stepCount = 2,
                               clusterCutoff = 1)


trimmedClusters = trimClusters(clusteredCds = clusteredCds,trimFactor = 1, clusterCutoff = 1)



fasta = paste(c(rep('A',25),
                rep('T',25),
                rep('A',10),
                rep('T',23)),collapse = "")

header = '>transcript1'


fastaFile = tempfile()
writeLines(paste(header,fasta,sep = "\n"),con = fastaFile)


rnaRefs = list()
rnaRefs[[rnas(cds)]] = read.fasta(fastaFile)
rnaRefs



foldedCds = foldComrades(trimmedClusters,
                         rnaRefs = rnaRefs,
                         start = 1,
                         end = 83,
                         shape = 0,
                         ensembl = 5,
                         constraintNumber  = 1,
                         evCutoff = 1)


plotStructure(foldedCds,rnaRefs,"s1",3)
}
}
