% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comtradr.R
\docType{package}
\name{comtradr}
\alias{comtradr}
\alias{comtradr-package}
\title{Interface to the United Nations Comtrade API}
\description{
Interface with and extract data from the United Nations
  Comtrade API. Comtrade provides country level shipping data for a variety
  of commodities, these functions allow for easy API query and data returned
  as a tidy data frame.
}
\section{Package Vignette}{


\itemize{
  \item \url{../doc/comtradr-vignette.html}
}
}

\section{Documentation for the Comtrade API}{


\itemize{
  \item Main Comtrade Site \url{https://comtrade.un.org/}
  \item Comtrade Data Query Web GUI \url{https://comtrade.un.org/data/}
  \item Full API Documentation \url{https://comtrade.un.org/data/doc/api/}
}
}

\section{Development links}{


\itemize{
  \item \url{https://github.com/ChrisMuir/comtradr}
  \item Report bugs at \url{https://github.com/ChrisMuir/comtradr/issues}
}
}

\section{\code{comtradr} features the following functions}{

\itemize{
  \item \code{\link{ct_commodity_db_type}}
  \item \code{\link{ct_commodity_lookup}}
  \item \code{\link{ct_country_lookup}}
  \item \code{\link{ct_get_remaining_hourly_queries}}
  \item \code{\link{ct_get_reset_time}}
  \item \code{\link{ct_register_token}}
  \item \code{\link{ct_search}}
  \item \code{\link{ct_update_databases}}
  \item \code{\link{ct_use_pretty_cols}}
}
}

