% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.data.R
\name{structure2conStruct}
\alias{structure2conStruct}
\title{Convert a dataset from STRUCTURE to conStruct format}
\usage{
structure2conStruct(infile, start.loci, missing.datum, outfile)
}
\arguments{
\item{infile}{The name and path of the file in STRUCTURE format 
to be converted to \code{conStruct} format.}

\item{start.loci}{The index of the first column in the dataset 
that contains genotype data.}

\item{missing.datum}{The character or value used to denote 
missing data in the STRUCTURE dataset (often -9).}

\item{outfile}{The name and path of the file containing the 
\code{conStruct} formatted dataset to be generated 
    by this function.}
}
\value{
This function returns an allele frequency data matrix 
	that can be used as the \code{freqs} argument in a conStruct 
	analysis run using \code{\link{conStruct}}.  It also saves 
	this object as an .RData file so that it can be used in 
	future analyses.
}
\description{
\code{structure2conStruct} converts a STRUCTURE dataset 
to conStruct format
}
\details{
This function takes a population genetics dataset in 
STRUCTURE format and converts it to conStruct format. 
The STRUCTURE file must have one row per individual 
and two columns per locus, and can only contain 
bi-allelic SNPs.

This function takes a STRUCTURE format data file and 
	converts it to a \code{conStruct} format data file. 
		The STRUCTURE dataset should be in the ONEROWPERIND 
		file format, with one row per individual and two columns 
		per locus (this function therefore can only be applied to 
		diploid organisms). The first column of the STRUCTURE dataset 
		should be individual names. There may be any number of other 
		columns that contain non-genotype information before the first
	column that contains genotype data, but there can 
		be no extraneous columns at the end of the dataset, after the 
		genotype data.  The genotype data should be bi-allelic 
	single nucleotide polymorphisms (SNPs).
}
