% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.output.R
\name{make.admix.pie.plot}
\alias{make.admix.pie.plot}
\title{Make admixture pie plot}
\usage{
make.admix.pie.plot(admix.proportions, coords, layer.colors = NULL,
  radii = 2.7, add = FALSE, x.lim = NULL, y.lim = NULL,
  mar = c(2, 2, 2, 2))
}
\arguments{
\item{admix.proportions}{A \code{matrix} of admixture proportions, 
with one row per sample and one column per layer.}

\item{coords}{\code{matrix} of sample coordinates, with one row 
per sample and two columns giving (respectively) the X 
and Y plotting coordinates.}

\item{layer.colors}{A \code{vector} of colors to be used in 
plotting results for different layers. Users must 
specify one color per layer.  If \code{NULL}, the plot 
will use a pre-specified vector of colors.}

\item{radii}{A \code{vector} of numeric values giving the radii to be 
used in plotting admixture pie plots. If the number of values 
specified is smaller than the number of samples, radii values 
will be recycled across samples. The default is 2.7.}

\item{add}{A \code{logical} value indicating whether to add the pie plots 
to an existing plot.  Default is \code{FALSE}.}

\item{x.lim}{A \code{vector} giving the x limits of the plot. The default
value is \code{NULL}, which indicates that the range of values 
given in the first column of \code{coords} should be used.}

\item{y.lim}{A \code{vector} giving the y limits of the plot. The default
value is \code{NULL}, which indicates that the range of values 
given in the second column of \code{coords} should be used.}

\item{mar}{A \code{vector} giving the number of lines of margin specified 
for the four sides of the plotting window (passed to \code{par}). 
Default value, which is only used if \code{add=FALSE}, is 
\code{c(2,2,2,2)}.}
}
\value{
This function has only invisible return values.
}
\description{
\code{make.structure.plot} makes a map of pie plots showing admixture 
proportions across layers.
}
\details{
This function takes the output from a conStruct analysis and 
makes a map of pie plots showing admixture proportions across layers, 
where each sample is represented as a pie chart, and the proportion of 
the pie of each color represent that sample's 
admixture proportion in that layer.
}
\examples{
\dontshow{
	admix.props <- matrix(c(0.086,0.000,0.500,0.505,0.099,0.052,0.024,0.007,0.800,0.000,0.216,0.744,0.917,0.199,0.469,0.000,0.783,0.298,0.329,0.446,0.000,0.000,0.637,0.903,0.000,0.000,0.000,0.012,0.021,0.000,0.000,0.089,0.000,0.554,0.002,0.000,0.000,0.095,0.020,0.001,0.001,0.011,0.000,0.200,0.000,0.060,0.053,0.082,0.036,0.013,0.000,0.062,0.169,0.137,0.029,0.001,0.000,0.178,0.079,0.000,0.999,1.000,0.988,0.979,0.975,1.000,0.744,0.984,0.435,0.998,0.914,1.000,0.405,0.475,0.900,0.947,0.965,0.993,0.000,1.000,0.725,0.203,0.000,0.765,0.518,1.000,0.154,0.533,0.534,0.525,0.999,1.000,0.185,0.018,1.000,0.001,0.000,0.000,0.000,0.025,0.000,0.167,0.016,0.012,0.000),ncol=3)
	coords <- matrix(c(-126.38,-125.23,-126.97,-128.54,-126.95,-121.71,-126.79,-123.38,-137.88,-125.82,-122.94,-130.73,-123.08,-122.84,-128.58,-124.82,-129.75,-122.25,-122.32,-129.10,-125.28,-123.98,-133.35,-131.74,-124.16,-146.35,-94.63,-149.02,-111.50,-126.67,-133.77,-118.63,-115.78,-113.42,-135.33,52.40,49.84,54.66,54.65,51.69,49.44,52.82,50.05,59.52,51.34,45.81,56.81,44.71,50.24,54.14,51.04,56.68,52.98,54.04,55.34,50.64,50.23,58.76,57.30,50.54,64.90,56.35,63.87,56.92,65.23,68.38,54.75,60.80,50.82,60.70),ncol=2)
}	
# make admixture pie plot
make.admix.pie.plot(admix.proportions = admix.props,coords = coords)

}
