% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dem_group.R
\name{dem_group}
\alias{dem_group}
\title{Average document-embeddings in a dem by a grouping variable}
\usage{
dem_group(x, groups = NULL)
}
\arguments{
\item{x}{a (\code{dem-class}) document-embedding-matrix}

\item{groups}{a character or factor variable equal in length to the number of documents}
}
\value{
a G x D (\code{dem-class}) document-embedding-matrix corresponding to the ALC embeddings for each group.
G = number of unique groups defined in the \code{groups} variable, D = dimensions of pretrained embeddings.
}
\description{
Average embeddings in a dem by a grouping variable, by averaging over columns within groups
and creating new "documents" with the group labels.
Similar in essence to \code{dfm_group}.
}
\examples{

library(quanteda)

# tokenize corpus
toks <- tokens(cr_sample_corpus)

# build a tokenized corpus of contexts sorrounding a target term
immig_toks <- tokens_context(x = toks, pattern = "immigr*", window = 6L)

# build document-feature matrix
immig_dfm <- dfm(immig_toks)

# construct document-embedding-matrix
immig_dem <- dem(immig_dfm, pre_trained = cr_glove_subset,
transform = TRUE, transform_matrix = cr_transform, verbose = FALSE)

# to get group-specific embeddings, average within party
immig_wv_party <- dem_group(immig_dem,
groups = immig_dem@docvars$party)
}
\keyword{dem_group}
