% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_context.R
\name{get_context}
\alias{get_context}
\title{Get context words (words within a symmetric window around the target word/phrase)
sorrounding a user defined target.}
\usage{
get_context(
  x,
  target,
  window = 6L,
  valuetype = "fixed",
  case_insensitive = TRUE,
  hard_cut = FALSE,
  what = "word",
  verbose = TRUE
)
}
\arguments{
\item{x}{(character) vector - this is the set of documents (corpus) of interest.}

\item{target}{(character) vector - these are the target words whose contexts we want to evaluate
This vector may include a single token, a phrase or multiple tokens and/or phrases.}

\item{window}{(numeric) - defines the size of a context (words around the target).}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \link[quanteda]{valuetype} for details.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link[quanteda]{dictionary} values}

\item{hard_cut}{(logical) - if TRUE then a context must have \code{window} x 2 tokens,
if FALSE it can have \code{window} x 2 or fewer (e.g. if a doc begins with a target word,
then context will have \code{window} tokens rather than \code{window} x 2)}

\item{what}{(character) defines which quanteda tokenizer to use. You will rarely want to change this.
For chinese text you may want to set \code{what = 'fastestword'}.}

\item{verbose}{(logical) - if TRUE, report the total number of target instances found.}
}
\value{
a \code{data.frame} with the following columns:
\describe{
\item{\code{docname}}{ (character) document name to which instances belong to.}
\item{\code{target}}{(character) targets.}
\item{\code{context}}{(numeric) pre/post variables in \code{kwic()} output concatenated.}
}
}
\description{
A wrapper function for quanteda's \code{kwic()} function that subsets documents to where
target is present before tokenizing to speed up processing, and concatenates
kwic's pre/post variables into a \code{context} column.
}
\note{
\code{target} in the return data.frame is equivalent to \code{kwic()}'s \code{keyword} output variable,
so it may not match the user-defined target exactly if \code{valuetype} is not fixed.
}
\examples{
# get context words sorrounding the term immigration
context_immigration <- get_context(x = cr_sample_corpus, target = 'immigration',
                                   window = 6, valuetype = "fixed", case_insensitive = FALSE,
                                   hard_cut = FALSE, verbose = FALSE)
}
\keyword{get_context}
