% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ncs.R
\name{get_ncs}
\alias{get_ncs}
\title{Given a set of tokenized contexts, find the top N nearest
contexts.}
\usage{
get_ncs(
  x,
  N = 5,
  groups = NULL,
  pre_trained,
  transform = TRUE,
  transform_matrix,
  bootstrap = TRUE,
  num_bootstraps = 10,
  as_list = TRUE
)
}
\arguments{
\item{x}{a (quanteda) \code{tokens-class} object}

\item{N}{(numeric) number of nearest contexts to return}

\item{groups}{a character or factor variable equal in length to the number of documents}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding.}

\item{transform}{(logical) if TRUE (default) apply the 'a la carte' transformation,
if FALSE ouput untransformed averaged embeddings.}

\item{transform_matrix}{(numeric) a D x D 'a la carte' transformation matrix.
D = dimensions of pretrained embeddings.}

\item{bootstrap}{(logical) if TRUE, use bootstrapping -- sample from \code{x} with replacement and
re-estimate cosine similarities for each sample. Required to get std. errors.
If \code{groups} defined, sampling is automatically stratified.}

\item{num_bootstraps}{(integer) number of bootstraps to use.}

\item{as_list}{(logical) if FALSE all results are combined into a single data.frame
If TRUE, a list of data.frames is returned with one data.frame per embedding}
}
\value{
a \code{data.frame} or list of data.frames (one for each target)
with the following columns:
\describe{
\item{\code{target}}{ (character) rownames of \code{x},
the labels of the ALC embeddings. \code{NA} if \code{is.null(rownames(x))}.}
\item{\code{context}}{(character) contexts collapsed into single documents (i.e. untokenized).}
\item{\code{rank}}{(character) rank of context in terms of similarity with \code{x}.}
\item{\code{value}}{(numeric) cosine similarity between \code{x} and context.}
\item{\code{std.error}}{(numeric) std. error of the similarity value.
Column is dropped if bootstrap = FALSE.}
}
}
\description{
This is a wrapper function for \code{ncs()} that allows users to go from a
tokenized corpus to results with the option to bootstrap cosine similarities
and get the corresponding std. errors.
}
\examples{

library(quanteda)

# tokenize corpus
toks <- tokens(cr_sample_corpus)

# build a tokenized corpus of contexts sorrounding a target term
immig_toks <- tokens_context(x = toks, pattern = "immigr*",
window = 6L, rm_keyword = FALSE)

# compare nearest contexts between groups
set.seed(2021L)
immig_party_ncs <- get_ncs(x = immig_toks,
                           N = 10,
                           groups = docvars(immig_toks, 'party'),
                           pre_trained = cr_glove_subset,
                           transform = TRUE,
                           transform_matrix = cr_transform,
                           bootstrap = TRUE,
                           num_bootstraps = 10,
                           as_list = TRUE)

# nearest neighbors of "immigration" for Republican party
immig_party_ncs[["D"]]
}
\keyword{get_ncs}
