% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{onesample_parameters}
\alias{onesample_parameters}
\alias{twosample_parameters}
\title{Return the one sample parameters used in fortran discrepancy
functions}
\usage{
onesample_parameters()

twosample_parameters()
}
\value{
a named list for each of the types.
}
\description{
These functions are mostly useful when one wants to
test one's own discrepancy function in R \code{f(y, z, w)} to
determine if the results are correct. So a natural test
is to experiment by programming one of the already implemented
discrepancy functions in R. However, the Fortran
implementations of such discrepancy measures use some
parameters in the computations and therefore the returned
results from a simple R implementation may not exactly
match. Using these parameters, one can ensure that they
do. These are to be interpreted as follows.  For one sample,
the \code{type = "dist"} implementation in the package returns 0 if
the length of \code{y} is less than \code{nmin} which is (100L). The \code{eps = 1.0e-5} parameter is used to ensure that the denominator in
the formula for the Anderson-Darling statistic is at least
\code{eps}. Next, for \code{type = "prob"}, if the length of the vector
is less than \code{nmin = 20} the discrepancy is computed to be
0. And so on. Refer to the R and Fortran source for further
details as this is an advanced topic.
}
