% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env_exists.R
\name{env_exists}
\alias{env_exists}
\title{Check If Environment Already exists}
\usage{
env_exists(env_name, verbose = "silent")
}
\arguments{
\item{env_name}{Character. Name of the Conda environment where the packages
are going to be installed. Defaults to 'condathis-env'.}

\item{verbose}{Character string specifying the verbosity level of the function's output. Acceptable values are:
\itemize{
\item \strong{"silent"}: Suppress all output from internal command-line tools. Equivalent to \code{FALSE}.
\item \strong{"cmd"}: Print the internal command(s) passed to the command-line tool.
\item \strong{"output"}: Print the standard output and error from the command-line tool to the screen. Note that the order of the standard output and error lines may not be correct, as standard output is typically buffered. If the standard output and/or error is redirected to a file or they are ignored, they will not be echoed.
\item \strong{"full"}: Print both the internal command(s) (\code{"cmd"}) and their standard output and error (\code{"output"}). Equivalent to \code{TRUE}.
Logical values \code{FALSE} and \code{TRUE} are also accepted for backward compatibility but are \emph{soft-deprecated}. Please use \code{"silent"} and \code{"full"} respectively instead.
}}
}
\value{
Boolean. \code{TRUE} if the environment exists and \code{FALSE} otherwise.
}
\description{
This function checks whether a specified Conda environment already exists
in the available environments. It returns \code{TRUE} if the environment exists
and \code{FALSE} otherwise.
}
\examples{
\dontrun{
condathis::with_sandbox_dir({
  # Create the environment
  condathis::create_env(
    packages = "fastqc",
    env_name = "fastqc-env"
  )

  # Check if the environment exists
  condathis::env_exists("fastqc-env")
  #> [1] TRUE

  # Check for a non-existent environment
  condathis::env_exists("non-existent-env")
  #> [1] FALSE
})
}

}
