% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write.config}
\alias{write.config}
\title{Write config in a file (JSON/YAML/INI)}
\usage{
write.config(config.dat, file.path = Sys.getenv("R_CONFIGFILE_ACTIVE",
  "config.cfg"), write.type = "ini", ...)
}
\arguments{
\item{config.dat}{a list of config (eg. generated by read.config)}

\item{file.path}{File path of configuration to write. Defaults to the value of
the ‘R_CONFIGFILE_ACTIVE’ environment variable ('config.cfg' if the
variable does not exist)}

\item{write.type}{json/ini/yaml}

\item{...}{Arguments for \code{\link[ini]{write.ini}}, 
\code{\link[jsonlite]{prettify}}, \code{\link[jsonlite]{toJSON}}, 
\code{\link[yaml]{as.yaml}} and \code{\link{cat}}
encoding if not specifield}
}
\value{
Logical indicating whether the specified configuration file be writed successful
}
\description{
Write config in a file (JSON/YAML/INI)
}
\examples{
list.test <- list(a=c(123,456))
out.yaml <- sprintf('\%s/test.yaml', tempdir()) 
write.config(list.test, out.yaml, write.type = 'yaml')
}
\seealso{
\code{\link[jsonlite]{toJSON}} convert a list to JSON string, 
\code{\link[jsonlite]{prettify}} convert a JSON string to user friendly view, 
\code{\link[ini]{write.ini}} write a list in a INI format file, 
\code{\link[yaml]{as.yaml}} convert a list to YAML format
}
