% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fungible.R
\encoding{UTF-8}
\name{fungible}
\alias{fungible}
\title{Locate extrema of fungible weights for regression and related models}
\usage{
fungible(
  object,
  theta = 0.005,
  Nstarts = 1000,
  MaxMin = c("min", "max"),
  silent = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted model object. Currently supported classes are: "cpa"}

\item{theta}{A vector of values to decrement from R-squared to compute families of fungible coefficients.}

\item{Nstarts}{Maximum number of (max) minimizations from random starting configurations.}

\item{MaxMin}{Should the cosine between the observed and alternative weights be maximized ("max") to find the maximally similar coefficients or minimized ("min") to find the maximally dissimilar coefficients?}

\item{silent}{Should current optimization values be printed to the console (\code{FALSE}) or suppressed (\code{TRUE})?}

\item{...}{Additional arguments}
}
\value{
A list containing the alternative weights and other fungible weights estimation parameters
}
\description{
Generates fungible regression weights (Waller, 2008) and related results using the method by Waller and Jones (2010).
}
\examples{
mind <- cpa_mat(mindfulness ~ ES + A + C + Ex + O,
                cov_mat = mindfulness$r,
                n = harmonic_mean(vechs(mindfulness$n)),
                se_var_mat = cor_covariance_meta(mindfulness$r,
                                                 mindfulness$n,
                                                 mindfulness$sevar_r,
                                                 mindfulness$source),
                adjust = "pop")
mind_fung <- fungible(mind, Nstarts = 100)
}
\references{
Waller, N. G. (2008).
Fungible weights in multiple regression.
\emph{Psychometrika, 73}(4), 691–703. \doi{10.1007/s11336-008-9066-z}

Waller, N. G., & Jones, J. A. (2009).
Locating the extrema of fungible regression weights.
\emph{Psychometrika, 74}(4), 589–602. \doi{10.1007/s11336-008-9087-7}
}
\author{
Niels Waller, Jeff Jones, Brenton M. Wiernik. Adapted from \code{fungible::fungibleExtrema()}.
}
