% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equivalence.R
\name{interpret_equivalence}
\alias{interpret_equivalence}
\title{Equivalence test interpretations of confidence intervals.}
\usage{
interpret_equivalence(ci, actual_null = 0, eq_margin = 0.1,
  groups = c("Control intervention", "Test intervention"),
  beneficial_outcome = TRUE)
}
\arguments{
\item{ci}{A single row from a matrix of the type returned by \code{confint()},
containing the confidence interval for the parameter estimate. The two
columns provide the lower and upper confidence limits.}

\item{actual_null}{The value that precisely zero difference would have in
the parameter being examined. For an absolute measure this will typically
be 0. For a relative measure it will typically be 1. This is the starting
point that the \code{eq_margin} is applied to in order to establish the
region for comparison.}

\item{eq_margin}{Numerical value specifying the equivalence margin
to be used.}

\item{groups}{A character vector of length 2 containing short descriptive names of the
groups being compared, such as the names of the interventions being
compared if the confidence interval is derived from an outcome effect
size measure in a randomised controlled trial. Give the name of the
intervention given to the comparison or control group first and the new
or tested intervention second.}

\item{beneficial_outcome}{Is the outcome to be treated as beneficial
(i.e., a higher value of the outcome is superior)? For harmful
outcomes (where lower numbers are better), set this to FALSE. If, for
example, the outcome is measuring something like prevalence of patients
recovering from a disease, that is likely to be beneficial; if it is
measuring the prevalence of patients falling ill with a disease it is
likely to be \strong{not} beneficial.}
}
\description{
Conduct equivalence tests on confidence intervals using a standard set of
interpretations. Takes a confidence interval around an effect size measure,
for example from the results from a randomised controlled trial comparing
the outcome for an intervention group to a control group.
}
\details{
Equivalence tests can be specified in analysis plans when the aim is to
check whether a new intervention performs the same as an old one.
The test is most appropriate
where the aim is not to result in a better or worse outcome, but the same as
under the previous intervention. One
particular use is for testing new versions of medicines, such as generic
versions of drugs after the branded version's patent protection has ended.
In this situation, if the generic manufacturer is correctly producing the
medicine it should result in neither better nor worse outcomes than the
branded medicine.

When conducting equivalence tests, an equivalence margin is specified. This
is the region around a true null (i.e., no difference) result that is deemed
to be within a reasonable range. It is commonly selected to include the
range of differences that would be of no practical significance.

You are able to supply descriptive names of the interventions being
compared, and these will be inserted into the resultant interpretation.
If the comparison / baseline intervention does not have a convenient name
(such as "Placebo"), some of these might be suitable:
\itemize{
 \item{"Business as usual"}
 \item{"Treatment as usual"}
 \item{"No intervention"}
}
(Whilst these may work well as short descriptions for outputting from
this function, in your reporting you will still normally want to provide
information about what exactly those in a comparison group got.)

This function is provided in the form of a convenience wrapper for
\code{\link{confinterpret}}, using
\code{\link{interpretations_superiority}} as its
\code{\link{interpretation_set}}.
}
