% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_measures_of_location.R
\name{ci_mean}
\alias{ci_mean}
\title{CI for the Population Mean}
\usage{
ci_mean(
  x,
  probs = c(0.025, 0.975),
  type = c("t", "Wald", "bootstrap"),
  boot_type = c("stud", "bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{probs}{Lower and upper probabilities, by default c(0.025, 0.975).}

\item{type}{Type of CI. One of "t" (default), "Wald", or "bootstrap".}

\item{boot_type}{Type of bootstrap CI ("stud", "bca", "perc", "norm", "basic").
Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{boot::boot()}.}
}
\value{
An object of class "cint" containing these components:
\itemize{
\item \code{parameter}: Parameter specification.
\item \code{interval}: CI for the parameter.
\item \code{estimate}: Parameter estimate.
\item \code{probs}: Lower and upper probabilities.
\item \code{type}: Type of interval.
\item \code{info}: Additional description.
}
}
\description{
This function calculates CIs for the population mean.
By default, Student's t method is used.
Alternatively, Wald and bootstrap CIs are available.
}
\details{
Bootstrap CIs are calculated by the package "boot", see references.
The default bootstrap type for the mean is "stud" (bootstrap t) as it enjoys the
property of being second order accurate and has a stable variance estimator
(see Efron, p. 188).
}
\examples{
x <- 1:100
ci_mean(x)
ci_mean(x, type = "bootstrap", R = 999, seed = 1)  # Use larger R
}
\references{
\enumerate{
\item Smithson, M. (2003). Confidence intervals. Series: Quantitative Applications in the Social Sciences. New York, NY: Sage Publications.
\item Efron, B. and Tibshirani R. J. (1994). An Introduction to the Bootstrap. Chapman & Hall/CRC.
\item Canty, A and Ripley B. (2019). boot: Bootstrap R (S-Plus) Functions.
}
}
