% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smqr.R
\name{conquer.reg}
\alias{conquer.reg}
\title{Penalized Convolution-Type Smoothed Quantile Regression}
\usage{
conquer.reg(
  X,
  Y,
  lambda = 0.2,
  tau = 0.5,
  kernel = c("Gaussian", "logistic", "uniform", "parabolic", "triangular"),
  h = 0,
  penalty = c("lasso", "scad", "mcp"),
  para = NULL,
  epsilon = 0.001,
  iteMax = 500,
  phi0 = 0.01,
  gamma = 1.2,
  iteTight = 3
)
}
\arguments{
\item{X}{A \eqn{n} by \eqn{p} design matrix. Each row is a vector of observation with \eqn{p} covariates.}

\item{Y}{An \eqn{n}-dimensional response vector.}

\item{lambda}{(\strong{optional}) Regularization parameter. Default is 0.2.}

\item{tau}{(\strong{optional}) Quantile level (between 0 and 1). Default is 0.5.}

\item{kernel}{(\strong{optional}) A character string specifying the choice of kernel function. Default is "Gaussian". Choices are "Gaussian", "logistic", "uniform", "parabolic" and "triangular".}

\item{h}{(\strong{optional}) Bandwidth/smoothing parameter. Default is \eqn{max{0.5 * (log(p) / n)^(1/4), 0.05}}.}

\item{penalty}{(\strong{optional}) A character string specifying the penalty. Default is "lasso". The other two options are "scad" and "mcp".}

\item{para}{(\strong{optional}) A constant parameter for "scad" and "mcp". Do not need to specify if the penalty is lasso. The default values are 3.7 for "scad" and 3 for "mcp".}

\item{epsilon}{(\strong{optional}) A tolerance level for the stopping rule. The iteration will stop when the maximum magnitude of the change of coefficient updates is less than \code{epsilon}. Default is 0.001.}

\item{iteMax}{(\strong{optional}) Maximum number of iterations. Default is 500.}

\item{phi0}{(\strong{optional}) The initial quadratic coefficient parameter in the local adaptive majorize-minimize algorithm. Default is 0.01.}

\item{gamma}{(\strong{optional}) The adaptive search parameter (greater than 1) in the local adaptive majorize-minimize algorithm. Default is 1.2.}

\item{iteTight}{(\strong{optional}) Maximum number of tightening iterations in the iteratively reweighted l_1-penalized algorithm. Do not need to specify if the penalty is lasso. Default is 3.}
}
\value{
An object containing the following items will be returned:
\describe{
\item{\code{coeff}}{A \eqn{(p + 1)} vector of estimated coefficients, including the intercept.}
\item{\code{bandwidth}}{Bandwidth value.}
\item{\code{tau}}{Quantile level.}
\item{\code{kernel}}{Kernel function.}
\item{\code{penalty}}{Penalty type.}
\item{\code{lambda}}{Regularization parameter.}
\item{\code{n}}{Sample size.}
\item{\code{p}}{Number of the covariates.}
}
}
\description{
Fit sparse quantile regression models in high dimensions via regularized conquer methods with "lasso", "scad" and "mcp" penalties. For "scad" and "mcp", the iteratively reweighted l_1-penalized algorithm is complemented with a local adpative majorize-minimize algorithm.
}
\examples{
n = 200; p = 500; s = 10
beta = c(rep(1.5, s), rep(0, p - s))
X = matrix(rnorm(n * p), n, p)
Y = X \%*\% beta + rt(n, 2)

## Regularized conquer with lasso penalty at tau = 0.8
fit.lasso = conquer.reg(X, Y, lambda = 0.05, tau = 0.8, kernel = "Gaussian", penalty = "lasso")
beta.lasso = fit.lasso$coeff

#' ## Regularized conquer with scad penalty at tau = 0.8
fit.scad = conquer.reg(X, Y, lambda = 0.13, tau = 0.8, kernel = "Gaussian", penalty = "scad")
beta.scad = fit.scad$coeff
}
\references{
Fan, J., Liu, H., Sun, Q. and Zhang, T. (2018). I-LAMM for sparse learning: Simultaneous control of algorithmic complexity and statistical error. Ann. Statist. 46 814-841.

Koenker, R. and Bassett, G. (1978). Regression quantiles. Econometrica 46 33-50.

Tan, K. M., Wang, L. and Zhou, W.-X. (2021). High-dimensional quantile regression: convolution smoothing and concave regularization. J. Roy. Statist. Soc. Ser. B, to appear.
}
\seealso{
See \code{\link{conquer.cv.reg}} for regularized quantile regression with cross-validation.
}
\author{
Xuming He <xmhe@umich.edu>, Xiaoou Pan <xip024@ucsd.edu>, Kean Ming Tan <keanming@umich.edu>, and Wen-Xin Zhou <wez243@ucsd.edu>
}
