% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{simplep}
\alias{simplep}
\title{simplep}
\usage{
simplep(theta, i_params)
}
\arguments{
\item{theta}{a scalar value of theta.}

\item{i_params}{an item design matrix that is of size response categories (k) by three. The three columns are:
\itemize{
\item column one is scoring values, usually from 0 to k.
\item column two is the delta dot parameter repeated k times (the average difficulty of the item)
\item column three is the tau (step) parameter where for k = 1, tau = 0, and for k >= 2,
subsequent entries are deviations from delta dot.
\item column four is the discrimination paramter ("a")
}}
}
\value{
a k x 1 matrix of response probabilities evaluated at theta.
}
\description{
returns response probabilities for each reponse category of an item at a given value of theta.
}
\examples{
myTheta <- 0
myDelta <- 1.5
a <- 1.5
k <- 3
itemParamX <- seq(0, k-1, 1)
itemParamD <- rep(myDelta, k)
itemParamT <- c(0, -0.5, 0.5)
itemParamA <- rep(a, k)
itemParam <- cbind(itemParamX, itemParamD, itemParamT, itemParamA)
colnames(itemParam)<- c("x", "d", "t", "a")
myProbs <- simplep(myTheta, itemParam)
}
\keyword{internal}
