% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{simplep}
\alias{simplep}
\title{simplep}
\usage{
simplep(theta, item, model = "conquest", D = 1)
}
\arguments{
\item{theta}{a scalar value of theta.}

\item{item}{an item design matrix that is of size response categories (m) by four:
\itemize{
\item column one is category values, usually from 0 to m. Sometimes referred to as 'x',
and in this case, this value times the discrimination is the category score.
\item column two is the delta dot parameter repeated m times (the average difficulty of the item)
\item column three is the tau (step) parameter where for the first response category (x = 0) tau = 0,
and for m >= 2, entries are deviations from delta dot. In the dichotomous case, all items
in this column are zero.
\item column four is the discrimination parameter ("a")
}}

\item{model}{a string, either "muraki"  or "conquest" (default) (see 10.1177/0146621697211001).
This tells downstream functions what parameterisation has been used for the model and helps with
plotting and other outputs.}

\item{D}{a number, giving the scaling constant. Default is 1 (logistic metric).
Other common values are D = 1.7 (to give the normal ogive metric)}
}
\value{
a k x 1 matrix of response probabilities evaluated at theta.
}
\description{
returns response probabilities for each response category of an item at a given value of theta.
}
\examples{
myTheta <- 0
myDelta <- 1.5
a <- 1.5
k <- 3
itemParamX <- seq(0, k-1, 1)
itemParamD <- c(0, rep(myDelta, k-1))
itemParamT <- c(0, -0.5, 0.5)
itemParamA <- rep(a, k)
itemParam <- cbind(itemParamX, itemParamD, itemParamT, itemParamA)
colnames(itemParam)<- c("x", "d", "t", "a")
myProbs <- simplep(myTheta, itemParam)
}
\keyword{internal}
