% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeContacts.R
\name{summarizeContacts}
\alias{summarizeContacts}
\title{Summarize Contact Events}
\usage{
summarizeContacts(
  x,
  importBlocks = FALSE,
  avg = FALSE,
  parallel = FALSE,
  nCores = (parallel::detectCores()/2)
)
}
\arguments{
\item{x}{Output from the contactDur.all or contactDur.area functions. Can 
be either a data frame or list of data frames.}

\item{importBlocks}{Logical. If true, each block in x will be analyzed 
separately. Defaults to FALSE. Note that the "block" column must exist 
in x.}

\item{avg}{Logical. If TRUE, summary output from all data frames contained 
in x will be averaged together. Output will produce an extra data frame 
containing the mean column values for each id (per block if 
importBlocks == TRUE). Defaults to FALSE.}

\item{parallel}{Logical. If TRUE, sub-functions within the summarizeContacts
wrapper will be parallelized. Note that the only sub-function 
parallelized here is called ONLY when importBlocks == TRUE.}

\item{nCores}{Integer. Describes the number of cores to be dedicated to 
parallel processes. Defaults to half of the maximum number of cores 
available (i.e., (parallel::detectCores()/2)).}
}
\value{
Returns a data frame (or list of data frames if \code{x} is a 
   list of data frames) with the following columns:
   
   \item{id}{The unique ID of a tracked individual for which we will 
   summarize to all other individuals/fixed locations observed in \code{x}.}
   \item{id}{Sum number of individuals/fixed locations observed in contact 
   specific individuals.}
   \item{id}{Sum number of contacts associated with specific individuals.}
   \item{contactDuration_...}{Number of contacts between specific dyads.} 
   
   If importBlocks == TRUE, the following columns are appended to the output
   data frame described above:
   
   \item{block}{Integer ID describing unique blocks of time during which 
   contacts occur.}
   \item{block.start}{The timepoint in \code{x} at which the \code{block}
   begins.}
   \item{block.end}{The timepoint in \code{x} at which the \code{block}
   ends.}
   \item{numBlocks}{Integer describing the total number of time blocks 
   observed within \code{x} at which the \code{block}}
}
\description{
This function takes the output from contactDur.all or contactDur.area and 
   reports the number of durations when tracked individuals are in "contact"
   with one another (contactDur.all) or with specified fixed points/polygons
   (contactDur.area).
}
\details{
If x is a list, and avg == TRUE, this function will produce an extra data 
   frame containing the mean column values for each id (per block if 
   importBlocks == TRUE).

This is a sub-function found within the contactTest and ntrkEdges function.
}
\examples{
data(calves)

calves.dateTime<-datetime.append(calves, date = calves$date, 
   time = calves$time) #create a dataframe with dateTime identifiers for location fixes

calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag, 
   dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x, 
   point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE, 
   extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE, 
   na.rm = TRUE, smooth.type = 1) #smooth to 5-min fix intervals.

calves.dist<-dist2All_df(x = calves.agg, parallel = FALSE, 
   dataType = "Point", lonlat = FALSE) 
calves.contact.block<-contactDur.all(x = calves.dist, dist.threshold=1, 
   sec.threshold=10, blocking = TRUE, blockUnit = "hours", blockLength = 1, 
   equidistant.time = FALSE, parallel = FALSE, reportParameters = TRUE) 
   
calves.contactSumm.NOblock <- summarizeContacts(calves.contact.block)
head(calves.contactSumm.NOblock)

calves.contactSumm.block <- summarizeContacts(calves.contact.block, 
   importBlocks = TRUE)
head(calves.contactSumm.block)
}
\keyword{contact}
\keyword{data-processing}
\keyword{sub-function}
