% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{replace}
\alias{replace}
\alias{ref_replace}
\alias{replace.Container}
\alias{ref_replace.Container}
\alias{replace.Dict}
\alias{ref_replace.Dict}
\title{Replace Values in Containers Safely}
\usage{
replace(.x, ...)

ref_replace(.x, ...)

\method{replace}{Container}(.x, old, new, add = FALSE, ...)

\method{ref_replace}{Container}(.x, old, new, add = FALSE, ...)

\method{replace}{Dict}(.x, old, new, ...)

\method{ref_replace}{Dict}(.x, old, new, ...)
}
\arguments{
\item{.x}{any \code{R} object.}

\item{...}{additional arguments to be passed to or from methods.}

\item{old}{old element to be found and replaced.}

\item{new}{the new element replacing the old one.}

\item{add}{\code{logical} if \code{FALSE} (default) and element was not found,
an error is given. In contrast, if set to \code{TRUE} the new element is added
regardless of whether it is used as a replacement for an existing element or
just added as a new element.}
}
\value{
For \code{Container}, an object of class \code{Container} (or one of the
respective derived classes).

For \code{Dict} an object of class \code{Dict}.
}
\description{
Try to find and replace elements and signal an error if not
found, unless it is stated to explicitly add the element (see option \code{add}).
}
\details{
\code{replace} uses copy semantics while \code{ref_replace} works by reference.
}
\examples{

co = container("x", 9)
replace(co, 9, 0)
replace(co, "x", 0)
\dontrun{
replace(co, "z", 0)              # old element ("z") is not in Container
}
replace(co, "z", 0, add = TRUE)  # just add the zero without replacement


d = dict(a = 1, b = "z")
replace(d, 1, 1:5)
replace(d, "z", "a")

\dontrun{
replace(d, "a", 2)              # old element ("a") is not in Dict
}
}
