% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addleft.R
\name{addleft}
\alias{addleft}
\alias{ref_addleft}
\alias{addleft.Deque}
\alias{ref_addleft.Deque}
\title{Add Elements to the Left of Deques}
\usage{
addleft(.x, ...)

ref_addleft(.x, ...)

\method{addleft}{Deque}(.x, ...)

\method{ref_addleft}{Deque}(.x, ...)
}
\arguments{
\item{.x}{a \verb{[Deque]} object}

\item{...}{elements to be added.}
}
\value{
For \link{Deque}, an object of class \link{Deque} with the elements being
added to the left of \code{.x}.
}
\description{
Add elements to left side of \link{Deque} objects.
}
\note{
While \link{addleft} uses copy semantics \link{ref_addleft} work by reference.
}
\examples{
d = deque(0)
add(d, a = 1, b = 2)         # |0, a = 1, b = 2|
addleft(d, a = 1, b = 2)     # |b = 2, a = 1, 0|
}
