% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_at.R
\name{replace_at}
\alias{replace_at}
\alias{ref_replace_at}
\alias{replace_at.Container}
\alias{ref_replace_at.Container}
\alias{replace_at.dict.table}
\alias{ref_replace_at.dict.table}
\title{Replace Values at Indices Safely}
\usage{
replace_at(.x, ...)

ref_replace_at(.x, ...)

\method{replace_at}{Container}(.x, ..., .add = FALSE)

\method{ref_replace_at}{Container}(.x, ..., .add = FALSE)

\method{replace_at}{dict.table}(.x, ..., .add = FALSE)

\method{ref_replace_at}{dict.table}(.x, ..., .add = FALSE)
}
\arguments{
\item{.x}{any \code{R} object.}

\item{...}{either name = value pairs or two vectors/lists with names/values
to be replaced.}

\item{.add}{\code{logical} if \code{FALSE} (default) and index is invalid, an error is
given. If set to \code{TRUE} the new element is added at the given index
regardless whether the index existed or not. Indices can consist of numbers
or names or both, except when adding values at new indices, which is only
allowed for names.}
}
\value{
For \code{Container}, an object of class \code{Container} (or one of the
respective derived classes).

For \code{dict.table} an object of class \code{dict.table}.
}
\description{
Try to find and replace elements at given indices and signal an
error if not found, unless it is stated to explicitly add the element (see
option \code{add}).
}
\details{
\code{replace_at} uses copy semantics while \code{ref_replace_at} works by
reference.
}
\examples{

co = container(a = 0, b = "z")
replace_at(co, a = 1, b = 2)
replace_at(co, 1:2, 1:2)                 # same
replace_at(co, c("a", "b"), list(1, 2))  # same

try({
replace_at(co, x = 1)                    # names(s) not found: 'x'
})
replace_at(co, x = 1, .add = TRUE)       # ok (adds x = 1)


dit = dict.table(a = 1:3, b = 4:6)
replace_at(dit, a = 3:1)
replace_at(dit, 1, 3:1)                  # same
replace_at(dit, "a", 3:1)                # same
replace_at(dit, a = 3:1, b = 6:4)
replace_at(dit, 1:2, list(3:1, 6:4))     # same

try({
replace_at(dit, x = 1)                   # column(s) not found: 'x'
})
replace_at(dit, x = 1, .add = TRUE)      # ok (adds column)
}
