% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spearman_correlation_coefficient_rxc.R
\name{Spearman_correlation_coefficient_rxc}
\alias{Spearman_correlation_coefficient_rxc}
\title{The Spearman correlation coefficient}
\usage{
Spearman_correlation_coefficient_rxc(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (an rxc matrix)}

\item{alpha}{the nominal significance level, used to compute a 100(1-alpha)# confidence interval}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing the Spearman correlation coefficient, and the Fieller and Bonett-Wright confidence intervals
}
\description{
The Spearman correlation coefficient

Described in Chapter 7 "The rxc Table"
}
\examples{
# Colorectal cancer (Table 7.7)
n <- rbind(
  c(2, 4, 29, 19), c(7, 6, 116, 51), c(19, 27, 201, 76), c(18, 22, 133, 54)
)
Spearman_correlation_coefficient_rxc(n)
\dontrun{
# Breast Tumor (Table 7.8)
n <- matrix(
  c(15, 35, 6, 9, 6, 2, 4, 2, 11, 11, 0, 0, 1, 10, 21),
  ncol = 5, byrow = TRUE
)
Spearman_correlation_coefficient_rxc(n)

# Self-rated health (Table 7.9)
n <- matrix(
  c(2, 3, 3, 3, 2, 58, 98, 14, 8, 162, 949, 252, 4, 48, 373, 369),
  ncol = 4, byrow = TRUE
)
Spearman_correlation_coefficient_rxc(n)
}

}
