% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pearson_LR_test_common_effect_stratified_2x2.R
\name{Pearson_LR_test_common_effect_stratified_2x2}
\alias{Pearson_LR_test_common_effect_stratified_2x2}
\title{The Pearson chi-squared and likelihood ratio tests of a common difference}
\usage{
Pearson_LR_test_common_effect_stratified_2x2(n, link = "logit")
}
\arguments{
\item{n}{the observed table (a 2x2xk matrix, where k is the number of strata)}

\item{link}{the link function ('linear', 'log', or 'logit')}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Pearson chi-squared and likelihood ratio tests of a common difference

between probabilities (link = 'linear'), ratio of probabilities (link =

'log'), or odds ratio (link = 'logit')

Described in Chapter 10 "Stratified 2x2 Tables and Meta-Analysis"
}
\examples{
# Smoking and lung cancer (Doll and Hill, 1950)
Pearson_LR_test_common_effect_stratified_2x2(doll_hill_1950)

# Prophylactice use of Lidocaine in myocardial infarction (Hine et al., 1989)
Pearson_LR_test_common_effect_stratified_2x2(hine_1989)

}
