% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\name{property}
\alias{property}
\alias{status}
\alias{optval}
\title{Get properties of optimization problem}
\usage{
status(p)

optval(p)
}
\arguments{
\item{p}{optimization problem.}
}
\description{
Get properties of solved optimization problem,
like the status of problem (optimal, infeasible and etc.),
or the optimal value of the solved optimization problem.
}
\examples{
\dontrun{
    convex_setup()
    x <- Variable(2)
    b <- J(c(1:2))
    p <- minimize(sum((x - b) ^ 2))
    cvx_optim(p)
    status(p)
    optval(p)
}
}
