% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coreHist.R
\name{coreHist}
\alias{coreHist}
\title{Whole-core frequency distribution of Hounsfield units}
\usage{
coreHist(directory = file.choose(), 
units = "percent",
upperLim = 3045, lowerLim = -1025,
airHU = -850.3233, airSD = 77.6953,
SiHU = 271.7827, SiSD = 39.2814,
glassHU = 1345.0696, glassSD = 45.4129,
waterHU = 63.912, waterSD = 14.1728,
returnData = TRUE, pngName = NULL)
}
\arguments{
\item{directory}{a character string that can be (1) a matrix of DICOM images that exists in the global environment, or (2) the address of an individual DICOM file in a folder of DICOM images. The default action is <code>file.choose()</code>; a browser menu appears so the user can select the the desired directory by identifying a single DICOM file in the folder of images.}

\item{units}{units used for plotting purposes only: either "percent" (the default) or "absolute". Returned data are always absolute pixel counts.}

\item{upperLim}{upper bound cutoff for pixels (Hounsfield Units); upper bound is inclusive}

\item{lowerLim}{lower bound cutoff for pixels (Hounsfield Units); lower bound is exclusive}

\item{airHU}{mean value for air-filled calibration rod (Hounsfield Units)}

\item{airSD}{standard deviation for air-filled calibration rod}

\item{SiHU}{mean value for colloidal silica calibration rod}

\item{SiSD}{standard deviation for colloidal Si calibration rod}

\item{glassHU}{mean value for glass calibration rod}

\item{glassSD}{standard deviation for glass calibration rod}

\item{waterHU}{mean value for water filled calibration rod}

\item{waterSD}{standard deviation for water filled calibration rod}

\item{returnData}{if \code{TRUE}, voxel counts for each Hounsfield unit from \code{lowerLim} to \code{upperLim} are returned, as are material class definitions. These are the data needed to re-create and modify the frequency plot.}

\item{pngName}{if this is not \code{NULL}, the frequency plot is saved to disk. In that case, \code{pngName} should be a character string containing the name and address of the file.}
}
\value{
list if \code{returnData = TRUE}, a list is returned containing the frequencies for each Hounsfield unit value from \code{lowerLim} to \code{upperLim}, and (2) the boundaries for material classes. Lower boundaries for a component class are exclusive, while upper bounds are inclusive. These materials allow the frequency distribution to be plotted by the user. If \code{returnData = FALSE} the data are plotted in the graphics window, but nothing is preserved.
}
\description{
Provides the raw data and plots a frequency distibution for Hounsfield Units in the entire core, also delineating material classes.
}
\examples{
# data(core_426)
coreHist("core_426", returnData = FALSE)

}
