/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.distance.measures;

import org.corehunter.data.CoreHunterData;
import org.corehunter.data.GenotypeData;
import org.corehunter.exceptions.CoreHunterException;
import org.corehunter.objectives.distance.measures.AbstractDistanceMeasure;

public class CavalliSforzaEdwardsDistance
extends AbstractDistanceMeasure {
    @Override
    public double computeDistance(int idX, int idY, CoreHunterData data) {
        if (idX == idY) {
            return 0.0;
        }
        GenotypeData genotypes = data.getGenotypicData();
        if (genotypes == null) {
            throw new CoreHunterException("Genotypes are required for Cavalli-Sforza and Edwards distance.");
        }
        int numberOfMarkers = genotypes.getNumberOfMarkers();
        double sumSquareDiff = 0.0;
        for (int markerIndex = 0; markerIndex < numberOfMarkers; ++markerIndex) {
            if (genotypes.hasMissingValues(idX, markerIndex) || genotypes.hasMissingValues(idY, markerIndex)) {
                sumSquareDiff += this.missingValueContribution(2.0);
                continue;
            }
            int numberOfAlleles = genotypes.getNumberOfAlleles(markerIndex);
            for (int alleleIndex = 0; alleleIndex < numberOfAlleles; ++alleleIndex) {
                double pxla = genotypes.getAlleleFrequency(idX, markerIndex, alleleIndex);
                double pyla = genotypes.getAlleleFrequency(idY, markerIndex, alleleIndex);
                double diff = Math.sqrt(pxla) - Math.sqrt(pyla);
                sumSquareDiff += diff * diff;
            }
        }
        double distance = Math.sqrt(sumSquareDiff / (double)(2 * numberOfMarkers));
        return distance;
    }

    public String toString() {
        return "Cavalli Sforza and Edwards";
    }
}

