/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.eval;

import java.util.Collection;
import java.util.Set;
import org.corehunter.data.GenotypeData;
import org.corehunter.objectives.eval.AllelicDiversityEvaluation;

public class ShannonEvaluation
extends AllelicDiversityEvaluation {
    public ShannonEvaluation(Collection<Integer> ids, GenotypeData data) {
        super(ids, data);
    }

    public ShannonEvaluation(AllelicDiversityEvaluation curEval, Set<Integer> add, Set<Integer> remove, GenotypeData data) {
        super(curEval, add, remove, data);
    }

    @Override
    public double getValue() {
        double[][] avgGeno = this.getAverageGenotype();
        double sum = 0.0;
        int numberOfMarkers = avgGeno.length;
        for (int m = 0; m < numberOfMarkers; ++m) {
            int numberOfAlleles = avgGeno[m].length;
            for (int a = 0; a < numberOfAlleles; ++a) {
                if (!(avgGeno[m][a] > 0.0)) continue;
                double scaledFreq = avgGeno[m][a] / (double)numberOfMarkers;
                sum += scaledFreq * Math.log(scaledFreq);
            }
        }
        return -sum;
    }
}

