% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execution.R
\name{getNormalizationRanges}
\alias{getNormalizationRanges}
\title{Determine normalization ranges of all objectives in a multi-objective configuration.}
\usage{
getNormalizationRanges(data, obj, size = 0.2, mode = c("default", "fast"),
  time = NA, impr.time = NA)
}
\arguments{
\item{data}{Core Hunter data (\code{chdata}) containing genotypes,
phenotypes and/or a precomputed distance matrix. Can also be an
object of class \code{chdist}, \code{chgeno} or \code{chpheno}
if only one type of data is provided.}

\item{obj}{List of objectives (\code{chobj}).
If no objectives are specified Core Hunter maximizes a weighted
index including the default entry-to-nearest-entry distance
(\code{EN}) for each available data type.
For genotyes, the Modified Roger's distance (\code{MR}) is
used. For phenotypes, Gower's distance (\code{GD}) is applied.}

\item{size}{Desired core subset size (numeric). If larger than one the value
is used as the absolute core size after rounding. Else it is used as the
sampling rate and multiplied with the dataset size to determine the size of
the core. The default sampling rate is 0.2.}

\item{mode}{Execution mode (\code{default} or \code{fast}). In default mode,
the normalization searches terminate when no improvement is found for ten
seconds. In fast mode, searches terminated as soon as no improvement is
made for two seconds. Stop conditions can be overriden with arguments
\code{time} and \code{impr.time}.}

\item{time}{Absolute runtime limit in seconds. Not used by default. If used
it should be a strictly positive value and is rounded to the nearest integer.}

\item{impr.time}{Maximum time without improvement in seconds. When set to
\code{NA} a default value is set depending on the execution \code{mode}.
If set to another value it should be strictly positive and is rounded
to the nearest integer.}
}
\value{
Numeric matrix with one row per objective and two columns:
\describe{
 \item{\code{lower}}{Lower bound of normalization range.}
 \item{\code{upper}}{Upper bound of normalization range.}
}
}
\description{
Executes an independent stochastic hill-climbing search per objective (in parallel) to
approximate the optimal solution for each objective from which a suitable normalization
range is inferred based on the Pareto minima/maxima. For an objective that is being maximized,
the upper bound is set to the value of the best solution for that objective, while
the lower bound is set to the Pareto minimum, i.e. the minimum value obtained when
evaluating all optimal solutions with the considered objective. For an objective that
is being minimized, the roles of upper and lower bound are interchanged, and the
Pareto maximum is used instead.
}
\examples{
\donttest{
data <- exampleData()

# maximize entry-to-nearest-entry distance between genotypes and phenotypes (equal weight)
objectives <- list(objective("EN", "MR"), objective("EN", "GD"))
# get normalization ranges for default size (20\%)
ranges <- getNormalizationRanges(data, obj = objectives, mode = "fast")

# set normalization ranges and sample core
objectives <- lapply(1:2, function(o){setRange(objectives[[o]], ranges[o,])})
core <- sampleCore(data, obj = objectives)
}

}
\seealso{
\code{\link{coreHunterData}}, \code{\link{objective}}
}

