% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cornet}
\alias{cornet}
\alias{cornet-package}
\title{Combined regression}
\usage{
cornet(y, cutoff, X, alpha = 1, npi = 101, pi = NULL, nsigma = 99,
  sigma = NULL, nfolds = 10, foldid = NULL,
  type.measure = "deviance", ...)
}
\arguments{
\item{y}{continuous outcome\strong{:}
vector of length \eqn{n}}

\item{cutoff}{cut-off point for dichotomising outcome into classes\strong{:}
\emph{meaningful} value between \code{min(y)} and \code{max(y)}}

\item{X}{features\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{alpha}{elastic net mixing parameter\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{npi}{number of \code{pi} values (weighting)}

\item{pi}{pi sequence\strong{:}
vector of increasing values in the unit interval;
or \code{NULL} (default sequence)}

\item{nsigma}{number of \code{sigma} values (scaling)}

\item{sigma}{sigma sequence\strong{:}
vector of increasing positive values;
or \code{NULL} (default sequence)}

\item{nfolds}{number of folds\strong{:}
integer between \eqn{3} and \eqn{n}}

\item{foldid}{fold identifiers\strong{:}
vector with entries between \eqn{1} and \code{nfolds};
or \code{NULL} (balance)}

\item{type.measure}{loss function for binary classification\strong{:}
character \code{"deviance"}, \code{"mse"}, \code{"mae"},
or \code{"class"} (see \code{\link[glmnet]{cv.glmnet}})}

\item{...}{further arguments passed to \code{\link[glmnet]{glmnet}}}
}
\value{
Returns an object of class \code{cornet}, a list with multiple slots:
\itemize{
   \item \code{gaussian}: fitted linear model, class \code{glmnet}
   \item \code{binomial}: fitted logistic model, class \code{glmnet}
   \item \code{sigma}: scaling parameters \code{sigma},
          vector of length \code{nsigma}
   \item \code{pi}: weighting parameters \code{pi},
          vector of length \code{npi}
   \item \code{cvm}: evaluation loss,
          matrix with \code{nsigma} rows and \code{npi} columns
   \item \code{sigma.min}: optimal scaling parameter,
          positive scalar
   \item \code{pi.min}: optimal weighting parameter,
          scalar in unit interval
   \item \code{cutoff}: threshold for dichotomisation
}
}
\description{
Implements lasso and ridge regression for dichotomised outcomes.
Such outcomes are not naturally but artificially binary.
They indicate whether an underlying measurement is greater than a threshold.
}
\details{
The argument \code{family} is unavailable, because
this function fits a \emph{gaussian} model for the numeric response,
and a \emph{binomial} model for the binary response.

Linear regression uses the loss function \code{"deviance"} (or \code{"mse"}),
but the loss is incomparable between linear and logistic regression.

The loss function \code{"auc"} is unavailable for internal cross-validation.
If at all, use \code{"auc"} for external cross-validation only.
}
\examples{
n <- 100; p <- 200
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
net <- cornet(y=y,cutoff=0,X=X)
net

}
\references{
Armin Rauschenberger and Enrico Glaab (2019).
"Lasso and ridge regression for dichotomised outcomes".
\emph{Manuscript in preparation}.
}
\seealso{
Methods for objects of class \code{cornet} include
\code{\link[=coef.cornet]{coef}} and
\code{\link[=predict.cornet]{predict}}.
}
