/* This file is automatically generated. DO NOT EDIT!
   Instead, edit gen-compose.py and re-run. */

/*
 * Unicode primary composites.
 *
 * Defined in Unicode Sec 3.11 "Normalization Forms"
 *
 * We use the two-stage lookup strategy described at
 *
 *     http://www.strchr.com/multi-stage_tables
 *
 */

#ifndef UNICODE_COMPOSE_H
#define UNICODE_COMPOSE_H

#include <stdint.h>

/* composition
 * -----------
 * offset: the offset into the primary and combiner arrays,
 *         or 0 if there are no compositions
 * length: the number of compositions for the codepont
 */
struct composition {
	unsigned offset : 11;
	unsigned length : 5;
};

#define COMPOSITION_BLOCK_SIZE 256

#define COMPOSITION_HANGUL_LPART 940

#define COMPOSITION_HANGUL_LVPART 941

static const uint8_t composition_stage1[] = {
/* U+0000 */  0,  1,  2,  3,  4,  5,  6,  5,  5,  7,  5,  8,  9, 10,  5,  5,
/* U+1000 */ 11, 12,  5,  5,  5,  5,  5,  5,  5,  5,  5, 13,  5,  5, 14, 15,
/* U+2000 */  5, 16, 17,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+3000 */ 18,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+4000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+5000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+6000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+7000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+8000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+9000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 19, 20, 21, 22,
/* U+B000 */ 23, 24, 25, 19, 20, 21, 22, 23, 24, 25, 19, 20, 21, 22, 23, 24,
/* U+C000 */ 25, 19, 20, 21, 22, 23, 24, 25, 19, 20, 21, 22, 23, 24, 25, 19,
/* U+D000 */ 20, 21, 22, 23, 24, 25, 19, 26,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+10000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+11000 */ 27, 28,  5, 29, 30, 31,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+12000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+13000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+14000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+15000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+16000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+17000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+18000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+19000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+1A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+1B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+1C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+1D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+1E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+1F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+20000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+21000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+22000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+23000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+24000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+25000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+26000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+27000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+28000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+29000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+2A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+2B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+2C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+2D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+2E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+2F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+30000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+31000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+32000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+33000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+34000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+35000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+36000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+37000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+38000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+39000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+3A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+3B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+3C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+3D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+3E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+3F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+40000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+41000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+42000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+43000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+44000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+45000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+46000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+47000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+48000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+49000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+4A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+4B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+4C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+4D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+4E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+4F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+50000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+51000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+52000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+53000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+54000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+55000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+56000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+57000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+58000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+59000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+5A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+5B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+5C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+5D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+5E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+5F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+60000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+61000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+62000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+63000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+64000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+65000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+66000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+67000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+68000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+69000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+6A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+6B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+6C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+6D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+6E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+6F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+70000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+71000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+72000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+73000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+74000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+75000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+76000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+77000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+78000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+79000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+7A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+7B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+7C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+7D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+7E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+7F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+80000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+81000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+82000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+83000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+84000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+85000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+86000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+87000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+88000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+89000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+8A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+8B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+8C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+8D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+8E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+8F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+90000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+91000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+92000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+93000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+94000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+95000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+96000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+97000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+98000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+99000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+9A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+9B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+9C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+9D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+9E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+9F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A0000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A1000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A2000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A3000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A4000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A5000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A6000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A7000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A8000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+A9000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+AA000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+AB000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+AC000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+AD000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+AE000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+AF000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B0000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B1000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B2000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B3000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B4000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B5000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B6000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B7000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B8000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+B9000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+BA000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+BB000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+BC000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+BD000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+BE000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+BF000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C0000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C1000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C2000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C3000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C4000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C5000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C6000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C7000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C8000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+C9000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+CA000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+CB000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+CC000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+CD000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+CE000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+CF000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D0000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D1000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D2000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D3000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D4000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D5000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D6000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D7000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D8000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+D9000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+DA000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+DB000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+DC000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+DD000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+DE000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+DF000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E0000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E1000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E2000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E3000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E4000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E5000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E6000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E7000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E8000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+E9000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+EA000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+EB000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+EC000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+ED000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+EE000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+EF000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F0000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F1000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F2000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F3000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F4000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F5000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F6000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F7000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F8000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+F9000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+FA000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+FB000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+FC000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+FD000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+FE000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+FF000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+100000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+101000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+102000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+103000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+104000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+105000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+106000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+107000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+108000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+109000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+10A000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+10B000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+10C000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+10D000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+10E000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* U+10F000 */  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5
};

static const struct composition composition_stage2[][256] = {
  /* block 0 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 1}, {  1, 1}, {  2, 1},
   {  0, 0}, {  0, 0}, {  3,16}, { 19, 3}, { 22, 5}, { 27, 6}, { 33,17},
   { 50, 1}, { 51, 7}, { 58, 7}, { 65,15}, { 80, 1}, { 81, 5}, { 86, 6},
   { 92, 3}, { 95, 9}, {104,16}, {120, 2}, {  0, 0}, {122, 8}, {130, 7},
   {137, 7}, {144,19}, {163, 2}, {165, 6}, {171, 2}, {173, 9}, {182, 6},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {188,16},
   {204, 3}, {207, 5}, {212, 6}, {218,17}, {235, 1}, {236, 7}, {243, 8},
   {251,14}, {265, 2}, {267, 5}, {272, 6}, {278, 3}, {281, 9}, {290,16},
   {306, 2}, {  0, 0}, {308, 8}, {316, 7}, {323, 8}, {331,19}, {350, 2},
   {352, 7}, {359, 2}, {361,10}, {371, 6}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {377, 3}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {380, 4}, {  0, 0},
   {384, 1}, {385, 1}, {386, 2}, {388, 1}, {  0, 0}, {  0, 0}, {389, 4},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {393, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {394, 4}, {398, 3}, {401, 1}, {  0, 0}, {402, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {403, 4}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {407, 4}, {  0, 0}, {411, 1}, {412, 1}, {413, 2},
   {415, 1}, {  0, 0}, {  0, 0}, {416, 4}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {420, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {421, 4},
   {425, 3}, {428, 1}, {  0, 0}, {429, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {430, 4}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 1 */
  {{  0, 0}, {  0, 0}, {434, 4}, {438, 4}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {442, 2}, {444, 2}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {446, 2},
   {448, 2}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {450, 1},
   {451, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {452, 1}, {453, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {454, 1},
   {455, 1}, {456, 1}, {457, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {458, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {459, 5},
   {464, 5}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {469, 5}, {474, 5}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {479, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {480, 1}, {481, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 2 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {482, 1}, {483, 1}, {484, 1}, {485, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {486, 1}, {487, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {488, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 3 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {489, 7}, {  0, 0},
   {  0, 0}, {  0, 0}, {496, 4}, {  0, 0}, {500, 5}, {  0, 0}, {505, 7},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {512, 4}, {  0, 0},
   {516, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {517, 6}, {  0, 0}, {  0, 0},
   {  0, 0}, {523, 5}, {  0, 0}, {  0, 0}, {528, 1}, {  0, 0}, {529, 1},
   {  0, 0}, {  0, 0}, {530, 8}, {  0, 0}, {  0, 0}, {  0, 0}, {538, 4},
   {  0, 0}, {542, 6}, {  0, 0}, {548, 8}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {556, 4}, {  0, 0}, {560, 2}, {  0, 0}, {  0, 0},
   {  0, 0}, {562, 8}, {  0, 0}, {  0, 0}, {  0, 0}, {570, 6}, {576, 3},
   {579, 3}, {  0, 0}, {  0, 0}, {582, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {583, 2}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 4 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {585, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {586, 2}, {  0, 0}, {  0, 0}, {588, 1}, {  0, 0},
   {589, 3}, {592, 2}, {594, 1}, {595, 4}, {  0, 0}, {599, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {600, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {601, 4}, {  0, 0}, {  0, 0}, {  0, 0}, {605, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {606, 1}, {  0, 0}, {607, 1}, {  0, 0}, {  0, 0}, {608, 2},
   {  0, 0}, {  0, 0}, {610, 1}, {  0, 0}, {611, 3}, {614, 2}, {616, 1},
   {617, 4}, {  0, 0}, {621, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {622, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {623, 4}, {  0, 0}, {  0, 0},
   {  0, 0}, {627, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {628, 1}, {  0, 0},
   {629, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {630, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {631, 1}, {632, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {633, 1},
   {634, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {635, 1}, {636, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 5 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 6 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {637, 3}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {640, 1}, {  0, 0}, {641, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {642, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {643, 1}, {  0, 0}, {  0, 0}, {644, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 7 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {645, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {646, 1},
   {  0, 0}, {  0, 0}, {647, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {648, 2}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 8 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {650, 3}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {653, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {654, 2}, {656, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 9 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {657, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {658, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {659, 3}, {  0, 0}, {  0, 0}, {  0, 0}, {662, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 10 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {663, 2}, {665, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {666, 3}, {  0, 0}, {  0, 0}, {669, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 11 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {670, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 12 */
  {{940, 1}, {940, 1}, {940, 1}, {940, 1}, {940, 1}, {940, 1}, {940, 1},
   {940, 1}, {940, 1}, {940, 1}, {940, 1}, {940, 1}, {940, 1}, {940, 1},
   {940, 1}, {940, 1}, {940, 1}, {940, 1}, {940, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 13 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {671, 1}, {  0, 0},
   {672, 1}, {  0, 0}, {673, 1}, {  0, 0}, {674, 1}, {  0, 0}, {675, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {676, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {677, 1}, {  0, 0}, {678, 1}, {  0, 0}, {679, 1},
   {680, 1}, {  0, 0}, {  0, 0}, {681, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 14 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {682, 1}, {683, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {684, 1},
   {685, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {686, 1}, {687, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {688, 2},
   {690, 2}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {692, 1}, {693, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {694, 1}, {695, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 15 */
  {{696, 4}, {700, 4}, {704, 1}, {705, 1}, {706, 1}, {707, 1}, {708, 1},
   {709, 1}, {710, 4}, {714, 4}, {718, 1}, {719, 1}, {720, 1}, {721, 1},
   {722, 1}, {723, 1}, {724, 2}, {726, 2}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {728, 2}, {730, 2}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {732, 4}, {736, 4}, {740, 1},
   {741, 1}, {742, 1}, {743, 1}, {744, 1}, {745, 1}, {746, 4}, {750, 4},
   {754, 1}, {755, 1}, {756, 1}, {757, 1}, {758, 1}, {759, 1}, {760, 3},
   {763, 3}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {766, 3}, {769, 3}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {772, 2}, {774, 2}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {776, 2}, {778, 2}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {780, 3}, {783, 3}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {786, 3}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {789, 4}, {793, 4},
   {797, 1}, {798, 1}, {799, 1}, {800, 1}, {801, 1}, {802, 1}, {803, 4},
   {807, 4}, {811, 1}, {812, 1}, {813, 1}, {814, 1}, {815, 1}, {816, 1},
   {817, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {818, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {819, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {820, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {821, 3}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {824, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {825, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {826, 3}, {  0, 0}
  },

  /* block 16 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {829, 1}, {  0, 0}, {830, 1},
   {  0, 0}, {831, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {832, 1}, {  0, 0},
   {833, 1}, {  0, 0}, {834, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 17 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {835, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {836, 1}, {  0, 0}, {  0, 0}, {837, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {838, 1}, {  0, 0}, {839, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {840, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {841, 1}, {  0, 0}, {842, 1},
   {  0, 0}, {  0, 0}, {843, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {844, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {845, 1},
   {  0, 0}, {  0, 0}, {846, 1}, {847, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {848, 1}, {849, 1}, {  0, 0}, {  0, 0}, {850, 1},
   {851, 1}, {  0, 0}, {  0, 0}, {852, 1}, {853, 1}, {854, 1}, {855, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {856, 1}, {857, 1}, {  0, 0},
   {  0, 0}, {858, 1}, {859, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {860, 1}, {861, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {862, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {863, 1}, {864, 1}, {  0, 0}, {865, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {866, 1}, {867, 1}, {868, 1}, {869, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 18 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {870, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {871, 1}, {  0, 0},
   {872, 1}, {  0, 0}, {873, 1}, {  0, 0}, {874, 1}, {  0, 0}, {875, 1},
   {  0, 0}, {876, 1}, {  0, 0}, {877, 1}, {  0, 0}, {878, 1}, {  0, 0},
   {879, 1}, {  0, 0}, {880, 1}, {  0, 0}, {881, 1}, {  0, 0}, {882, 1},
   {  0, 0}, {  0, 0}, {883, 1}, {  0, 0}, {884, 1}, {  0, 0}, {885, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {886, 2},
   {  0, 0}, {  0, 0}, {888, 2}, {  0, 0}, {  0, 0}, {890, 2}, {  0, 0},
   {  0, 0}, {892, 2}, {  0, 0}, {  0, 0}, {894, 2}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {896, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {897, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {898, 1}, {  0, 0}, {899, 1}, {  0, 0},
   {900, 1}, {  0, 0}, {901, 1}, {  0, 0}, {902, 1}, {  0, 0}, {903, 1},
   {  0, 0}, {904, 1}, {  0, 0}, {905, 1}, {  0, 0}, {906, 1}, {  0, 0},
   {907, 1}, {  0, 0}, {908, 1}, {  0, 0}, {909, 1}, {  0, 0}, {  0, 0},
   {910, 1}, {  0, 0}, {911, 1}, {  0, 0}, {912, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {913, 2}, {  0, 0}, {  0, 0},
   {915, 2}, {  0, 0}, {  0, 0}, {917, 2}, {  0, 0}, {  0, 0}, {919, 2},
   {  0, 0}, {  0, 0}, {921, 2}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {923, 1}, {924, 1}, {925, 1}, {926, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {927, 1}, {  0, 0}, {  0, 0}
  },

  /* block 19 */
  {{941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 20 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 21 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 22 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 23 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 24 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 25 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 26 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {941, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 27 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {928, 1},
   {  0, 0}, {929, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {930, 1}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 28 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {931, 1}, {932, 1}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 29 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {933, 2}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 30 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {935, 3}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  },

  /* block 31 */
  {{  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {938, 1}, {939, 1}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0},
   {  0, 0}, {  0, 0}, {  0, 0}, {  0, 0}
  }
};

static const uint32_t composition_combiner[] = {
/*   0 */ 0x0338,0x0338,0x0338,0x0300,0x0301,0x0302,0x0303,0x0304,
/*   8 */ 0x0306,0x0307,0x0308,0x0309,0x030A,0x030C,0x030F,0x0311,
/*  16 */ 0x0323,0x0325,0x0328,0x0307,0x0323,0x0331,0x0301,0x0302,
/*  24 */ 0x0307,0x030C,0x0327,0x0307,0x030C,0x0323,0x0327,0x032D,
/*  32 */ 0x0331,0x0300,0x0301,0x0302,0x0303,0x0304,0x0306,0x0307,
/*  40 */ 0x0308,0x0309,0x030C,0x030F,0x0311,0x0323,0x0327,0x0328,
/*  48 */ 0x032D,0x0330,0x0307,0x0301,0x0302,0x0304,0x0306,0x0307,
/*  56 */ 0x030C,0x0327,0x0302,0x0307,0x0308,0x030C,0x0323,0x0327,
/*  64 */ 0x032E,0x0300,0x0301,0x0302,0x0303,0x0304,0x0306,0x0307,
/*  72 */ 0x0308,0x0309,0x030C,0x030F,0x0311,0x0323,0x0328,0x0330,
/*  80 */ 0x0302,0x0301,0x030C,0x0323,0x0327,0x0331,0x0301,0x030C,
/*  88 */ 0x0323,0x0327,0x032D,0x0331,0x0301,0x0307,0x0323,0x0300,
/*  96 */ 0x0301,0x0303,0x0307,0x030C,0x0323,0x0327,0x032D,0x0331,
/* 104 */ 0x0300,0x0301,0x0302,0x0303,0x0304,0x0306,0x0307,0x0308,
/* 112 */ 0x0309,0x030B,0x030C,0x030F,0x0311,0x031B,0x0323,0x0328,
/* 120 */ 0x0301,0x0307,0x0301,0x0307,0x030C,0x030F,0x0311,0x0323,
/* 128 */ 0x0327,0x0331,0x0301,0x0302,0x0307,0x030C,0x0323,0x0326,
/* 136 */ 0x0327,0x0307,0x030C,0x0323,0x0326,0x0327,0x032D,0x0331,
/* 144 */ 0x0300,0x0301,0x0302,0x0303,0x0304,0x0306,0x0308,0x0309,
/* 152 */ 0x030A,0x030B,0x030C,0x030F,0x0311,0x031B,0x0323,0x0324,
/* 160 */ 0x0328,0x032D,0x0330,0x0303,0x0323,0x0300,0x0301,0x0302,
/* 168 */ 0x0307,0x0308,0x0323,0x0307,0x0308,0x0300,0x0301,0x0302,
/* 176 */ 0x0303,0x0304,0x0307,0x0308,0x0309,0x0323,0x0301,0x0302,
/* 184 */ 0x0307,0x030C,0x0323,0x0331,0x0300,0x0301,0x0302,0x0303,
/* 192 */ 0x0304,0x0306,0x0307,0x0308,0x0309,0x030A,0x030C,0x030F,
/* 200 */ 0x0311,0x0323,0x0325,0x0328,0x0307,0x0323,0x0331,0x0301,
/* 208 */ 0x0302,0x0307,0x030C,0x0327,0x0307,0x030C,0x0323,0x0327,
/* 216 */ 0x032D,0x0331,0x0300,0x0301,0x0302,0x0303,0x0304,0x0306,
/* 224 */ 0x0307,0x0308,0x0309,0x030C,0x030F,0x0311,0x0323,0x0327,
/* 232 */ 0x0328,0x032D,0x0330,0x0307,0x0301,0x0302,0x0304,0x0306,
/* 240 */ 0x0307,0x030C,0x0327,0x0302,0x0307,0x0308,0x030C,0x0323,
/* 248 */ 0x0327,0x032E,0x0331,0x0300,0x0301,0x0302,0x0303,0x0304,
/* 256 */ 0x0306,0x0308,0x0309,0x030C,0x030F,0x0311,0x0323,0x0328,
/* 264 */ 0x0330,0x0302,0x030C,0x0301,0x030C,0x0323,0x0327,0x0331,
/* 272 */ 0x0301,0x030C,0x0323,0x0327,0x032D,0x0331,0x0301,0x0307,
/* 280 */ 0x0323,0x0300,0x0301,0x0303,0x0307,0x030C,0x0323,0x0327,
/* 288 */ 0x032D,0x0331,0x0300,0x0301,0x0302,0x0303,0x0304,0x0306,
/* 296 */ 0x0307,0x0308,0x0309,0x030B,0x030C,0x030F,0x0311,0x031B,
/* 304 */ 0x0323,0x0328,0x0301,0x0307,0x0301,0x0307,0x030C,0x030F,
/* 312 */ 0x0311,0x0323,0x0327,0x0331,0x0301,0x0302,0x0307,0x030C,
/* 320 */ 0x0323,0x0326,0x0327,0x0307,0x0308,0x030C,0x0323,0x0326,
/* 328 */ 0x0327,0x032D,0x0331,0x0300,0x0301,0x0302,0x0303,0x0304,
/* 336 */ 0x0306,0x0308,0x0309,0x030A,0x030B,0x030C,0x030F,0x0311,
/* 344 */ 0x031B,0x0323,0x0324,0x0328,0x032D,0x0330,0x0303,0x0323,
/* 352 */ 0x0300,0x0301,0x0302,0x0307,0x0308,0x030A,0x0323,0x0307,
/* 360 */ 0x0308,0x0300,0x0301,0x0302,0x0303,0x0304,0x0307,0x0308,
/* 368 */ 0x0309,0x030A,0x0323,0x0301,0x0302,0x0307,0x030C,0x0323,
/* 376 */ 0x0331,0x0300,0x0301,0x0342,0x0300,0x0301,0x0303,0x0309,
/* 384 */ 0x0304,0x0301,0x0301,0x0304,0x0301,0x0300,0x0301,0x0303,
/* 392 */ 0x0309,0x0301,0x0300,0x0301,0x0303,0x0309,0x0301,0x0304,
/* 400 */ 0x0308,0x0304,0x0301,0x0300,0x0301,0x0304,0x030C,0x0300,
/* 408 */ 0x0301,0x0303,0x0309,0x0304,0x0301,0x0301,0x0304,0x0301,
/* 416 */ 0x0300,0x0301,0x0303,0x0309,0x0301,0x0300,0x0301,0x0303,
/* 424 */ 0x0309,0x0301,0x0304,0x0308,0x0304,0x0301,0x0300,0x0301,
/* 432 */ 0x0304,0x030C,0x0300,0x0301,0x0303,0x0309,0x0300,0x0301,
/* 440 */ 0x0303,0x0309,0x0300,0x0301,0x0300,0x0301,0x0300,0x0301,
/* 448 */ 0x0300,0x0301,0x0307,0x0307,0x0307,0x0307,0x0301,0x0301,
/* 456 */ 0x0308,0x0308,0x0307,0x0300,0x0301,0x0303,0x0309,0x0323,
/* 464 */ 0x0300,0x0301,0x0303,0x0309,0x0323,0x0300,0x0301,0x0303,
/* 472 */ 0x0309,0x0323,0x0300,0x0301,0x0303,0x0309,0x0323,0x030C,
/* 480 */ 0x0304,0x0304,0x0304,0x0304,0x0306,0x0306,0x0304,0x0304,
/* 488 */ 0x030C,0x0300,0x0301,0x0304,0x0306,0x0313,0x0314,0x0345,
/* 496 */ 0x0300,0x0301,0x0313,0x0314,0x0300,0x0301,0x0313,0x0314,
/* 504 */ 0x0345,0x0300,0x0301,0x0304,0x0306,0x0308,0x0313,0x0314,
/* 512 */ 0x0300,0x0301,0x0313,0x0314,0x0314,0x0300,0x0301,0x0304,
/* 520 */ 0x0306,0x0308,0x0314,0x0300,0x0301,0x0313,0x0314,0x0345,
/* 528 */ 0x0345,0x0345,0x0300,0x0301,0x0304,0x0306,0x0313,0x0314,
/* 536 */ 0x0342,0x0345,0x0300,0x0301,0x0313,0x0314,0x0300,0x0301,
/* 544 */ 0x0313,0x0314,0x0342,0x0345,0x0300,0x0301,0x0304,0x0306,
/* 552 */ 0x0308,0x0313,0x0314,0x0342,0x0300,0x0301,0x0313,0x0314,
/* 560 */ 0x0313,0x0314,0x0300,0x0301,0x0304,0x0306,0x0308,0x0313,
/* 568 */ 0x0314,0x0342,0x0300,0x0301,0x0313,0x0314,0x0342,0x0345,
/* 576 */ 0x0300,0x0301,0x0342,0x0300,0x0301,0x0342,0x0345,0x0301,
/* 584 */ 0x0308,0x0308,0x0306,0x0308,0x0301,0x0300,0x0306,0x0308,
/* 592 */ 0x0306,0x0308,0x0308,0x0300,0x0304,0x0306,0x0308,0x0301,
/* 600 */ 0x0308,0x0304,0x0306,0x0308,0x030B,0x0308,0x0308,0x0308,
/* 608 */ 0x0306,0x0308,0x0301,0x0300,0x0306,0x0308,0x0306,0x0308,
/* 616 */ 0x0308,0x0300,0x0304,0x0306,0x0308,0x0301,0x0308,0x0304,
/* 624 */ 0x0306,0x0308,0x030B,0x0308,0x0308,0x0308,0x0308,0x030F,
/* 632 */ 0x030F,0x0308,0x0308,0x0308,0x0308,0x0653,0x0654,0x0655,
/* 640 */ 0x0654,0x0654,0x0654,0x0654,0x0654,0x093C,0x093C,0x093C,
/* 648 */ 0x09BE,0x09D7,0x0B3E,0x0B56,0x0B57,0x0BD7,0x0BBE,0x0BD7,
/* 656 */ 0x0BBE,0x0C56,0x0CD5,0x0CC2,0x0CD5,0x0CD6,0x0CD5,0x0D3E,
/* 664 */ 0x0D57,0x0D3E,0x0DCA,0x0DCF,0x0DDF,0x0DCA,0x102E,0x1B35,
/* 672 */ 0x1B35,0x1B35,0x1B35,0x1B35,0x1B35,0x1B35,0x1B35,0x1B35,
/* 680 */ 0x1B35,0x1B35,0x0304,0x0304,0x0304,0x0304,0x0307,0x0307,
/* 688 */ 0x0302,0x0306,0x0302,0x0306,0x0302,0x0302,0x0302,0x0302,
/* 696 */ 0x0300,0x0301,0x0342,0x0345,0x0300,0x0301,0x0342,0x0345,
/* 704 */ 0x0345,0x0345,0x0345,0x0345,0x0345,0x0345,0x0300,0x0301,
/* 712 */ 0x0342,0x0345,0x0300,0x0301,0x0342,0x0345,0x0345,0x0345,
/* 720 */ 0x0345,0x0345,0x0345,0x0345,0x0300,0x0301,0x0300,0x0301,
/* 728 */ 0x0300,0x0301,0x0300,0x0301,0x0300,0x0301,0x0342,0x0345,
/* 736 */ 0x0300,0x0301,0x0342,0x0345,0x0345,0x0345,0x0345,0x0345,
/* 744 */ 0x0345,0x0345,0x0300,0x0301,0x0342,0x0345,0x0300,0x0301,
/* 752 */ 0x0342,0x0345,0x0345,0x0345,0x0345,0x0345,0x0345,0x0345,
/* 760 */ 0x0300,0x0301,0x0342,0x0300,0x0301,0x0342,0x0300,0x0301,
/* 768 */ 0x0342,0x0300,0x0301,0x0342,0x0300,0x0301,0x0300,0x0301,
/* 776 */ 0x0300,0x0301,0x0300,0x0301,0x0300,0x0301,0x0342,0x0300,
/* 784 */ 0x0301,0x0342,0x0300,0x0301,0x0342,0x0300,0x0301,0x0342,
/* 792 */ 0x0345,0x0300,0x0301,0x0342,0x0345,0x0345,0x0345,0x0345,
/* 800 */ 0x0345,0x0345,0x0345,0x0300,0x0301,0x0342,0x0345,0x0300,
/* 808 */ 0x0301,0x0342,0x0345,0x0345,0x0345,0x0345,0x0345,0x0345,
/* 816 */ 0x0345,0x0345,0x0345,0x0345,0x0345,0x0300,0x0301,0x0342,
/* 824 */ 0x0345,0x0345,0x0300,0x0301,0x0342,0x0338,0x0338,0x0338,
/* 832 */ 0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,
/* 840 */ 0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,
/* 848 */ 0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,
/* 856 */ 0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,
/* 864 */ 0x0338,0x0338,0x0338,0x0338,0x0338,0x0338,0x3099,0x3099,
/* 872 */ 0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,
/* 880 */ 0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,0x309A,
/* 888 */ 0x3099,0x309A,0x3099,0x309A,0x3099,0x309A,0x3099,0x309A,
/* 896 */ 0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,
/* 904 */ 0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,0x3099,
/* 912 */ 0x3099,0x3099,0x309A,0x3099,0x309A,0x3099,0x309A,0x3099,
/* 920 */ 0x309A,0x3099,0x309A,0x3099,0x3099,0x3099,0x3099,0x3099,
/* 928 */ 0x110BA,0x110BA,0x110BA,0x11127,0x11127,0x1133E,0x11357,0x114B0,
/* 936 */ 0x114BA,0x114BD,0x115AF,0x115AF
};

static const uint32_t composition_primary[] = {
/*   0 */ 0x226E,0x2260,0x226F,0x00C0,0x00C1,0x00C2,0x00C3,0x0100,
/*   8 */ 0x0102,0x0226,0x00C4,0x1EA2,0x00C5,0x01CD,0x0200,0x0202,
/*  16 */ 0x1EA0,0x1E00,0x0104,0x1E02,0x1E04,0x1E06,0x0106,0x0108,
/*  24 */ 0x010A,0x010C,0x00C7,0x1E0A,0x010E,0x1E0C,0x1E10,0x1E12,
/*  32 */ 0x1E0E,0x00C8,0x00C9,0x00CA,0x1EBC,0x0112,0x0114,0x0116,
/*  40 */ 0x00CB,0x1EBA,0x011A,0x0204,0x0206,0x1EB8,0x0228,0x0118,
/*  48 */ 0x1E18,0x1E1A,0x1E1E,0x01F4,0x011C,0x1E20,0x011E,0x0120,
/*  56 */ 0x01E6,0x0122,0x0124,0x1E22,0x1E26,0x021E,0x1E24,0x1E28,
/*  64 */ 0x1E2A,0x00CC,0x00CD,0x00CE,0x0128,0x012A,0x012C,0x0130,
/*  72 */ 0x00CF,0x1EC8,0x01CF,0x0208,0x020A,0x1ECA,0x012E,0x1E2C,
/*  80 */ 0x0134,0x1E30,0x01E8,0x1E32,0x0136,0x1E34,0x0139,0x013D,
/*  88 */ 0x1E36,0x013B,0x1E3C,0x1E3A,0x1E3E,0x1E40,0x1E42,0x01F8,
/*  96 */ 0x0143,0x00D1,0x1E44,0x0147,0x1E46,0x0145,0x1E4A,0x1E48,
/* 104 */ 0x00D2,0x00D3,0x00D4,0x00D5,0x014C,0x014E,0x022E,0x00D6,
/* 112 */ 0x1ECE,0x0150,0x01D1,0x020C,0x020E,0x01A0,0x1ECC,0x01EA,
/* 120 */ 0x1E54,0x1E56,0x0154,0x1E58,0x0158,0x0210,0x0212,0x1E5A,
/* 128 */ 0x0156,0x1E5E,0x015A,0x015C,0x1E60,0x0160,0x1E62,0x0218,
/* 136 */ 0x015E,0x1E6A,0x0164,0x1E6C,0x021A,0x0162,0x1E70,0x1E6E,
/* 144 */ 0x00D9,0x00DA,0x00DB,0x0168,0x016A,0x016C,0x00DC,0x1EE6,
/* 152 */ 0x016E,0x0170,0x01D3,0x0214,0x0216,0x01AF,0x1EE4,0x1E72,
/* 160 */ 0x0172,0x1E76,0x1E74,0x1E7C,0x1E7E,0x1E80,0x1E82,0x0174,
/* 168 */ 0x1E86,0x1E84,0x1E88,0x1E8A,0x1E8C,0x1EF2,0x00DD,0x0176,
/* 176 */ 0x1EF8,0x0232,0x1E8E,0x0178,0x1EF6,0x1EF4,0x0179,0x1E90,
/* 184 */ 0x017B,0x017D,0x1E92,0x1E94,0x00E0,0x00E1,0x00E2,0x00E3,
/* 192 */ 0x0101,0x0103,0x0227,0x00E4,0x1EA3,0x00E5,0x01CE,0x0201,
/* 200 */ 0x0203,0x1EA1,0x1E01,0x0105,0x1E03,0x1E05,0x1E07,0x0107,
/* 208 */ 0x0109,0x010B,0x010D,0x00E7,0x1E0B,0x010F,0x1E0D,0x1E11,
/* 216 */ 0x1E13,0x1E0F,0x00E8,0x00E9,0x00EA,0x1EBD,0x0113,0x0115,
/* 224 */ 0x0117,0x00EB,0x1EBB,0x011B,0x0205,0x0207,0x1EB9,0x0229,
/* 232 */ 0x0119,0x1E19,0x1E1B,0x1E1F,0x01F5,0x011D,0x1E21,0x011F,
/* 240 */ 0x0121,0x01E7,0x0123,0x0125,0x1E23,0x1E27,0x021F,0x1E25,
/* 248 */ 0x1E29,0x1E2B,0x1E96,0x00EC,0x00ED,0x00EE,0x0129,0x012B,
/* 256 */ 0x012D,0x00EF,0x1EC9,0x01D0,0x0209,0x020B,0x1ECB,0x012F,
/* 264 */ 0x1E2D,0x0135,0x01F0,0x1E31,0x01E9,0x1E33,0x0137,0x1E35,
/* 272 */ 0x013A,0x013E,0x1E37,0x013C,0x1E3D,0x1E3B,0x1E3F,0x1E41,
/* 280 */ 0x1E43,0x01F9,0x0144,0x00F1,0x1E45,0x0148,0x1E47,0x0146,
/* 288 */ 0x1E4B,0x1E49,0x00F2,0x00F3,0x00F4,0x00F5,0x014D,0x014F,
/* 296 */ 0x022F,0x00F6,0x1ECF,0x0151,0x01D2,0x020D,0x020F,0x01A1,
/* 304 */ 0x1ECD,0x01EB,0x1E55,0x1E57,0x0155,0x1E59,0x0159,0x0211,
/* 312 */ 0x0213,0x1E5B,0x0157,0x1E5F,0x015B,0x015D,0x1E61,0x0161,
/* 320 */ 0x1E63,0x0219,0x015F,0x1E6B,0x1E97,0x0165,0x1E6D,0x021B,
/* 328 */ 0x0163,0x1E71,0x1E6F,0x00F9,0x00FA,0x00FB,0x0169,0x016B,
/* 336 */ 0x016D,0x00FC,0x1EE7,0x016F,0x0171,0x01D4,0x0215,0x0217,
/* 344 */ 0x01B0,0x1EE5,0x1E73,0x0173,0x1E77,0x1E75,0x1E7D,0x1E7F,
/* 352 */ 0x1E81,0x1E83,0x0175,0x1E87,0x1E85,0x1E98,0x1E89,0x1E8B,
/* 360 */ 0x1E8D,0x1EF3,0x00FD,0x0177,0x1EF9,0x0233,0x1E8F,0x00FF,
/* 368 */ 0x1EF7,0x1E99,0x1EF5,0x017A,0x1E91,0x017C,0x017E,0x1E93,
/* 376 */ 0x1E95,0x1FED,0x0385,0x1FC1,0x1EA6,0x1EA4,0x1EAA,0x1EA8,
/* 384 */ 0x01DE,0x01FA,0x01FC,0x01E2,0x1E08,0x1EC0,0x1EBE,0x1EC4,
/* 392 */ 0x1EC2,0x1E2E,0x1ED2,0x1ED0,0x1ED6,0x1ED4,0x1E4C,0x022C,
/* 400 */ 0x1E4E,0x022A,0x01FE,0x01DB,0x01D7,0x01D5,0x01D9,0x1EA7,
/* 408 */ 0x1EA5,0x1EAB,0x1EA9,0x01DF,0x01FB,0x01FD,0x01E3,0x1E09,
/* 416 */ 0x1EC1,0x1EBF,0x1EC5,0x1EC3,0x1E2F,0x1ED3,0x1ED1,0x1ED7,
/* 424 */ 0x1ED5,0x1E4D,0x022D,0x1E4F,0x022B,0x01FF,0x01DC,0x01D8,
/* 432 */ 0x01D6,0x01DA,0x1EB0,0x1EAE,0x1EB4,0x1EB2,0x1EB1,0x1EAF,
/* 440 */ 0x1EB5,0x1EB3,0x1E14,0x1E16,0x1E15,0x1E17,0x1E50,0x1E52,
/* 448 */ 0x1E51,0x1E53,0x1E64,0x1E65,0x1E66,0x1E67,0x1E78,0x1E79,
/* 456 */ 0x1E7A,0x1E7B,0x1E9B,0x1EDC,0x1EDA,0x1EE0,0x1EDE,0x1EE2,
/* 464 */ 0x1EDD,0x1EDB,0x1EE1,0x1EDF,0x1EE3,0x1EEA,0x1EE8,0x1EEE,
/* 472 */ 0x1EEC,0x1EF0,0x1EEB,0x1EE9,0x1EEF,0x1EED,0x1EF1,0x01EE,
/* 480 */ 0x01EC,0x01ED,0x01E0,0x01E1,0x1E1C,0x1E1D,0x0230,0x0231,
/* 488 */ 0x01EF,0x1FBA,0x0386,0x1FB9,0x1FB8,0x1F08,0x1F09,0x1FBC,
/* 496 */ 0x1FC8,0x0388,0x1F18,0x1F19,0x1FCA,0x0389,0x1F28,0x1F29,
/* 504 */ 0x1FCC,0x1FDA,0x038A,0x1FD9,0x1FD8,0x03AA,0x1F38,0x1F39,
/* 512 */ 0x1FF8,0x038C,0x1F48,0x1F49,0x1FEC,0x1FEA,0x038E,0x1FE9,
/* 520 */ 0x1FE8,0x03AB,0x1F59,0x1FFA,0x038F,0x1F68,0x1F69,0x1FFC,
/* 528 */ 0x1FB4,0x1FC4,0x1F70,0x03AC,0x1FB1,0x1FB0,0x1F00,0x1F01,
/* 536 */ 0x1FB6,0x1FB3,0x1F72,0x03AD,0x1F10,0x1F11,0x1F74,0x03AE,
/* 544 */ 0x1F20,0x1F21,0x1FC6,0x1FC3,0x1F76,0x03AF,0x1FD1,0x1FD0,
/* 552 */ 0x03CA,0x1F30,0x1F31,0x1FD6,0x1F78,0x03CC,0x1F40,0x1F41,
/* 560 */ 0x1FE4,0x1FE5,0x1F7A,0x03CD,0x1FE1,0x1FE0,0x03CB,0x1F50,
/* 568 */ 0x1F51,0x1FE6,0x1F7C,0x03CE,0x1F60,0x1F61,0x1FF6,0x1FF3,
/* 576 */ 0x1FD2,0x0390,0x1FD7,0x1FE2,0x03B0,0x1FE7,0x1FF4,0x03D3,
/* 584 */ 0x03D4,0x0407,0x04D0,0x04D2,0x0403,0x0400,0x04D6,0x0401,
/* 592 */ 0x04C1,0x04DC,0x04DE,0x040D,0x04E2,0x0419,0x04E4,0x040C,
/* 600 */ 0x04E6,0x04EE,0x040E,0x04F0,0x04F2,0x04F4,0x04F8,0x04EC,
/* 608 */ 0x04D1,0x04D3,0x0453,0x0450,0x04D7,0x0451,0x04C2,0x04DD,
/* 616 */ 0x04DF,0x045D,0x04E3,0x0439,0x04E5,0x045C,0x04E7,0x04EF,
/* 624 */ 0x045E,0x04F1,0x04F3,0x04F5,0x04F9,0x04ED,0x0457,0x0476,
/* 632 */ 0x0477,0x04DA,0x04DB,0x04EA,0x04EB,0x0622,0x0623,0x0625,
/* 640 */ 0x0624,0x0626,0x06C2,0x06D3,0x06C0,0x0929,0x0931,0x0934,
/* 648 */ 0x09CB,0x09CC,0x0B4B,0x0B48,0x0B4C,0x0B94,0x0BCA,0x0BCC,
/* 656 */ 0x0BCB,0x0C48,0x0CC0,0x0CCA,0x0CC7,0x0CC8,0x0CCB,0x0D4A,
/* 664 */ 0x0D4C,0x0D4B,0x0DDA,0x0DDC,0x0DDE,0x0DDD,0x1026,0x1B06,
/* 672 */ 0x1B08,0x1B0A,0x1B0C,0x1B0E,0x1B12,0x1B3B,0x1B3D,0x1B40,
/* 680 */ 0x1B41,0x1B43,0x1E38,0x1E39,0x1E5C,0x1E5D,0x1E68,0x1E69,
/* 688 */ 0x1EAC,0x1EB6,0x1EAD,0x1EB7,0x1EC6,0x1EC7,0x1ED8,0x1ED9,
/* 696 */ 0x1F02,0x1F04,0x1F06,0x1F80,0x1F03,0x1F05,0x1F07,0x1F81,
/* 704 */ 0x1F82,0x1F83,0x1F84,0x1F85,0x1F86,0x1F87,0x1F0A,0x1F0C,
/* 712 */ 0x1F0E,0x1F88,0x1F0B,0x1F0D,0x1F0F,0x1F89,0x1F8A,0x1F8B,
/* 720 */ 0x1F8C,0x1F8D,0x1F8E,0x1F8F,0x1F12,0x1F14,0x1F13,0x1F15,
/* 728 */ 0x1F1A,0x1F1C,0x1F1B,0x1F1D,0x1F22,0x1F24,0x1F26,0x1F90,
/* 736 */ 0x1F23,0x1F25,0x1F27,0x1F91,0x1F92,0x1F93,0x1F94,0x1F95,
/* 744 */ 0x1F96,0x1F97,0x1F2A,0x1F2C,0x1F2E,0x1F98,0x1F2B,0x1F2D,
/* 752 */ 0x1F2F,0x1F99,0x1F9A,0x1F9B,0x1F9C,0x1F9D,0x1F9E,0x1F9F,
/* 760 */ 0x1F32,0x1F34,0x1F36,0x1F33,0x1F35,0x1F37,0x1F3A,0x1F3C,
/* 768 */ 0x1F3E,0x1F3B,0x1F3D,0x1F3F,0x1F42,0x1F44,0x1F43,0x1F45,
/* 776 */ 0x1F4A,0x1F4C,0x1F4B,0x1F4D,0x1F52,0x1F54,0x1F56,0x1F53,
/* 784 */ 0x1F55,0x1F57,0x1F5B,0x1F5D,0x1F5F,0x1F62,0x1F64,0x1F66,
/* 792 */ 0x1FA0,0x1F63,0x1F65,0x1F67,0x1FA1,0x1FA2,0x1FA3,0x1FA4,
/* 800 */ 0x1FA5,0x1FA6,0x1FA7,0x1F6A,0x1F6C,0x1F6E,0x1FA8,0x1F6B,
/* 808 */ 0x1F6D,0x1F6F,0x1FA9,0x1FAA,0x1FAB,0x1FAC,0x1FAD,0x1FAE,
/* 816 */ 0x1FAF,0x1FB2,0x1FC2,0x1FF2,0x1FB7,0x1FCD,0x1FCE,0x1FCF,
/* 824 */ 0x1FC7,0x1FF7,0x1FDD,0x1FDE,0x1FDF,0x219A,0x219B,0x21AE,
/* 832 */ 0x21CD,0x21CF,0x21CE,0x2204,0x2209,0x220C,0x2224,0x2226,
/* 840 */ 0x2241,0x2244,0x2247,0x2249,0x226D,0x2262,0x2270,0x2271,
/* 848 */ 0x2274,0x2275,0x2278,0x2279,0x2280,0x2281,0x22E0,0x22E1,
/* 856 */ 0x2284,0x2285,0x2288,0x2289,0x22E2,0x22E3,0x22AC,0x22AD,
/* 864 */ 0x22AE,0x22AF,0x22EA,0x22EB,0x22EC,0x22ED,0x3094,0x304C,
/* 872 */ 0x304E,0x3050,0x3052,0x3054,0x3056,0x3058,0x305A,0x305C,
/* 880 */ 0x305E,0x3060,0x3062,0x3065,0x3067,0x3069,0x3070,0x3071,
/* 888 */ 0x3073,0x3074,0x3076,0x3077,0x3079,0x307A,0x307C,0x307D,
/* 896 */ 0x309E,0x30F4,0x30AC,0x30AE,0x30B0,0x30B2,0x30B4,0x30B6,
/* 904 */ 0x30B8,0x30BA,0x30BC,0x30BE,0x30C0,0x30C2,0x30C5,0x30C7,
/* 912 */ 0x30C9,0x30D0,0x30D1,0x30D3,0x30D4,0x30D6,0x30D7,0x30D9,
/* 920 */ 0x30DA,0x30DC,0x30DD,0x30F7,0x30F8,0x30F9,0x30FA,0x30FE,
/* 928 */ 0x1109A,0x1109C,0x110AB,0x1112E,0x1112F,0x1134B,0x1134C,0x114BC,
/* 936 */ 0x114BB,0x114BE,0x115BA,0x115BB
};

#endif /* UNICODE_COMPOSE_H */
