% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_functions.R
\name{bf_func}
\alias{bf_func}
\title{Calculate ABFs from Z scores}
\usage{
bf_func(z, V, W = 0.2)
}
\arguments{
\item{z}{Vector of Z-scores}

\item{V}{Variance of the estimated effect size}

\item{W}{Prior for the standard deviation of the effect size parameter, beta (default 0.2)}
}
\value{
ABFs
}
\description{
Calculate ABFs from Z scores
}
\details{
Note, z and V should both be vectors or both be matrices
}
\examples{

set.seed(1)
nsnps = 100
N0 = 5000
N1 = 5000
z_scores <- rnorm(nsnps, 0, 3)

## generate example LD matrix and MAFs
library(mvtnorm)
nsamples = 1000

simx <- function(nsnps, nsamples, S, maf=0.1) {
    mu <- rep(0,nsnps)
    rawvars <- rmvnorm(n=nsamples, mean=mu, sigma=S)
    pvars <- pnorm(rawvars)
    x <- qbinom(1-pvars, 1, maf)
}

S <- (1 - (abs(outer(1:nsnps,1:nsnps,`-`))/nsnps))^4
X <- simx(nsnps,nsamples,S)
maf <- colMeans(X)

varbeta = Var.data.cc(f = maf, N = N0 + N1, s = 0.5)

bf_func(z_scores, V = varbeta)

}
