% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\docType{package}
\name{corregp-package}
\alias{corregp-package}
\title{Functions and Methods for Correspondence Regression}
\description{
This package provides functions and methods for performing correspondence regression, i.e. the correspondence analysis of the
  crosstabulation of a categorical variable Y in function of another one X, where X can in turn be made up of the combination of various
  categorical variables.  
  Consequently, correspondence regression can be used to analyze the effects for a polytomous or multinomial outcome variable.  
  The central function in the package is \code{\link{corregp}}, which enables methods for printing, summarizing and plotting the output.  
  Additionally, there are functions for computing confidence intervals, ellipses or 3D ellipsoids (by means of bootstrapping).
}
\section{Contents}{

This package consists of the following datasets, functions, generics and methods:  
\subsection{Datasets}{
  \itemize{
    \item{\code{\link{HairEye}} }{Hair and eye color of statistics students (data frame).}
    \item{\code{\link{COMURE}} }{The use of linguistic variants in translations vs. non-translations and in six different registers.}
    \item{\code{\link{TSS}}} {The use of inflected or uninflected determiners in vernacular Belgian Dutch.}
  }
}
\subsection{Functions}{
  \itemize{
    \item{\code{\link{ci}} }{A helper function to compute confidence intervals on the basis of a numeric vector.}
    \item{\code{\link{confGet}} }{An internal function to retrieve the \code{conf} components in a \code{corregp} object.}
    \item{\code{\link{corregp}} }{The basic function to perform correspondence regression. Typically, one starts here, and then one uses \code{print}, \code{summary}, \code{anova}, \code{screeplot} or \code{plot} methods.}
  }
}
\subsection{Generics}{
  \itemize{
    \item{\code{\link{cint}} }{Compute confidence intervals.}
    \item{\code{\link{cell}} }{Compute confidence ellipses.}
    \item{\code{\link{cell3d}} }{Compute 3D confidence ellipsoids.}
    \item{\code{\link{ciplot}} }{Plot confidence intervals.}
    \item{\code{\link{pcplot}} }{Plot parallel coordinates.}
    \item{\code{\link{agplot}} }{Plot an association graph.}
    \item{\code{\link{plotag}} }{Plot an association graph.}
  }
}
\subsection{Methods}{
  \itemize{
    \item{\code{\link{print.corregp}} }{Print the output of a correspondence regression.}
    \item{\code{\link{summary.corregp}} }{Give a \code{summary} of a correspondence regression.}
    \item{\code{\link{print.summary.corregp}} }{Print the \code{summary} of a correspondence regression.}
    \item{\code{\link{screeplot.corregp}} }{Make a scree plot on the basis of the output of a correspondence regression.}
    \item{\code{\link{anova.corregp}} }{Give an \code{anova} table on the basis of a correspondence regression.}
    \item{\code{\link{print.anova.corregp}} }{Print an \code{anova} table on the basis of a correspondence regression.}
    \item{\code{\link{coef.corregp}} }{Give the coefficients on the basis of a correspondence regression.}
    \item{\code{\link{coefficients.corregp}} }{Give the coefficients on the basis of a correspondence regression.}
    \item{\code{\link{fitted.corregp}} }{Give the fitted values on the basis of a correspondence regression.}
    \item{\code{\link{fitted.values.corregp}} }{Give the fitted values on the basis of a correspondence regression.}
    \item{\code{\link{residuals.corregp}} }{Give the residuals on the basis of a correspondence regression.}
    \item{\code{\link{resid.corregp}} }{Give the residuals on the basis of a correspondence regression.}
    \item{\code{\link{cint.corregp}} }{Compute confidence intervals on the basis of the output of a correspondence regression. Typically, this function is not so much used directly as it is called by a \code{ciplot.corregp} command.}
    \item{\code{\link{ciplot.corregp}} }{Plot confidence intervals on the basis of the output of a correspondence regression.}
    \item{\code{\link{pcplot.corregp}} }{Make a parallel coordinate plot on the basis of the output of a correspondence regression.}
    \item{\code{\link{cell.corregp}} }{Compute confidence ellipses on the basis of the output of a correspondence regression. Typically, this function is not so much used directly as it is called by a \code{plot.corregp} command.}
    \item{\code{\link{plot.corregp}} }{Plot the output (and the optional confidence ellipses) of a correspondence regression.}
    \item{\code{\link{cell3d.corregp}} }{Compute 3D confidence ellipsoids on the basis of a correspondence regression. Typically, this function is not so much used directly as it is called by a \code{plot3d.corregp} command.}
    \item{\code{\link{plot3d.corregp}} }{Plot the 3D output (and the optional confidence ellipsoids) of a correspondence regression.}
    \item{\code{\link{agplot.corregp}} }{Make an association graph on the basis of the output of a correspondence regression.}
    \item{\code{\link{plotag.corregp}} }{Make an association graph on the basis of the output of a correspondence regression.}
  }
}
}

\section{Future prospects}{

\itemize{
  \item Specify a \code{predict} method for a.o. supplementary points.
  \item Enable scale transformations for all plots (and corresponding confidence regions).
  \item Provide the possibility for so-called "calibration lines".
}
}

\section{Author}{

Koen Plevoets, \email{koen.plevoets@kuleuven.be}
}

\section{Acknowledgements}{

This package has benefited greatly from the helpful comments of Isabelle Delaere and Gert De Sutter. Thanks to Kurt Hornik and Uwe Ligges for proofing this package.
}

