% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R, R/print_md.R
\name{display.easycormatrix}
\alias{display.easycormatrix}
\alias{print_md.easycormatrix}
\title{Export tables into different output formats}
\usage{
\method{display}{easycormatrix}(object, format = "markdown", digits = 2, stars = TRUE, ...)

\method{print_md}{easycormatrix}(x, digits = 2, stars = TRUE, ...)
}
\arguments{
\item{object, x}{An object returned by \code{\link[=correlation]{correlation()}}
or its summary.}

\item{format}{String, indicating the output format. Currently, only
\code{"markdown"} is supported.}

\item{digits}{To do...}

\item{stars}{To do...}

\item{...}{Currently not used.}
}
\value{
A character vector. If \code{format = "markdown"}, the return value
  will be a character vector in markdown-table format.
}
\description{
Export tables (i.e. data frame) into different output formats.
  \code{print_md()} is a alias for \code{display(format = "markdown")}.
}
\details{
\code{display()} is useful when the table-output from functions,
  which is usually printed as formatted text-table to console, should
  be formatted for pretty table-rendering in markdown documents, or if
  knitted from rmarkdown to PDF or Word files.
}
\examples{
data(iris)
corr <- correlation(iris)
display(corr)

s <- summary(corr)
display(s)
}
