% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scatter}
\alias{scatter}
\title{scatter - XY scatter plot with extra information}
\usage{
scatter(
  x,
  y,
  method = "pearson",
  threshold = 0.01,
  showLine = TRUE,
  bgcol = FALSE,
  pch = 20,
  subtitle = NULL,
  extendXlim = FALSE,
  ...
)
}
\arguments{
\item{x}{The first named vector}

\item{y}{The second named vector}

\item{method}{a character string indicating which correlation coefficient is to
be computed. One of "pearson" (default), "kendall", or "spearman": can be abbreviated.}

\item{threshold}{a numeric value indicating the significance threshold (p-value) of the correlation,
in order to show a colored background. Default is 0.01.}

\item{showLine}{a boolean indicating if a linear regression line should be plotted. Default is
TRUE}

\item{bgcol}{Boolean. Should a background coloring associated to significance and sign of
correlation be used? Default is TRUE, and it will color the background in red if the correlation
coefficient is positive, in blue if negative, in white if not significant (accordin to the
_threshold_ parameter)}

\item{pch}{the _pch_ parameter indicating the points shape. Default is 20}

\item{subtitle}{NULL by default, in which case the function will print as a subtitle the correlation
coefficient (CC) and its pvalue. Otherwise, a user-provided string, bypassing the predefined subtitle}

\item{extendXlim}{logical. If TRUE, the x-axis limits are extended by a fraction (useful for
labeling points on the margins of the plot area). Default is FALSE}

\item{...}{Arguments to be passed to the core _plot_ function}
}
\value{
A plot
}
\description{
This function will plot two variables (based on their common names), calculate their
Coefficient of Correlation (CC), plot a linear regression line and color the background
if the correlation is positive (red), negative
(blue) or non-significant (white)
}
\examples{
x<-setNames(rnorm(200),paste0("var",1:200))
y<-setNames(rnorm(210),paste0("var",11:220))
scatter(x,y,xlab="Variable x",ylab="Variable y",main="Scatter plot by corto package")
}
