% Generated by roxygen2 (4.0.1): do not edit by hand
\name{summary.cosinor.lm}
\alias{summary.cosinor.lm}
\title{Summarize a cosinor model}
\usage{
\method{summary}{cosinor.lm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{cosinor.lm}}

\item{...}{Currently unusued}
}
\description{
Given a time variable and optional covariates, generate inference a cosinor
fit. Gives estimates, confidence intervals, and tests for the raw parameters,
and for the mean, amplitude, and acrophase parameters. If the model includes
covariates, the function returns the estimates of the mean, amplitude, and
acrophase for the group with covariates equal to 1 and equal to 0. This may
not be the desired result for continuous covariates.
}
\examples{
fit <- cosinor.lm(Y ~ time(time) + X + amp.acro(X), data = vitamind)
summary(fit)
}

