% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor.lm.R
\name{cosinor.lm}
\alias{cosinor.lm}
\title{Fit cosinor model}
\usage{
cosinor.lm(formula, period = 12, data, na.action = na.omit)
}
\arguments{
\item{formula}{Formula specifying the model. Indicate the time variable with
\code{time()} and covariate effects on the amplitude and acrophase with
\code{amp.acro()}. See details for more information.}

\item{period}{Length of time for a complete period of the sine curve.}

\item{data}{Data frame where variable can be found}

\item{na.action}{What to do with missing data}
}
\description{
Given an outcome and time variable, fit the cosinor model with optional
covariate effects.
}
\details{
This defines special functions that are used in the formula to
  indicate the time variable and which covariates effect the amplitude. To
  indicate the time variable wrap the name of it in the function
  \code{time()}. To indicate a variable which affects the
  acrophase/amplitude, wrap the name in \code{amp.acro()}. This will then do
  all the transformations for you. See examples for usage.
}
\examples{

cosinor.lm(Y ~ time(time) + X + amp.acro(X), data = vitamind)

}
\references{
Tong, YL. Parameter Estimation in Studying Circadian Rhythms, Biometrics (1976). 32(1):85--94.
}
