% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR_frequentist.R
\name{pvals}
\alias{pvals}
\title{Compute coefficient p-values for STAR linear regression using likelihood ratio test}
\usage{
pvals(object)
}
\arguments{
\item{object}{Object of class "lmstar" as output by \code{\link{lm_star}}}
}
\value{
a list of p+1 p-values, one for each predictor as well as the joint
p-value excluding all predictors
}
\description{
For a linear regression model within the STAR framework,
compute p-values for regression coefficients using a likelihood ratio test.
It also computes a p-value for excluding all predictors, akin to a (partial)
F test.
}
\examples{
# Simulate data with count-valued response y:
sim_dat = simulate_nb_lm(n = 100, p = 2)
y = sim_dat$y; X = sim_dat$X

# Select a transformation:
transformation = 'np'

#Estimate model
fit = lm_star(y~X, transformation = transformation)

#Compute p-values
pvals(fit)

}
