% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_tools.R
\name{changePixelColor}
\alias{changePixelColor}
\title{Change all specified pixels to a new color}
\usage{
changePixelColor(pixel.array, pixel.idx, target.color = "green",
  return.img = FALSE, plotting = TRUE, main = "")
}
\arguments{
\item{pixel.array}{An image represented as a 3D array (as read in by
\code{\link[jpeg]{readJPEG}}, \code{\link[png]{readPNG}}, or
\code{\link[colordistance]{loadImage}}) in which to change pixel colors.}

\item{pixel.idx}{An n x 2 matrix of index coordinates specifying which pixels
to change, where rows are pixels and columns are X and Y coordinates in the
image.}

\item{target.color}{Color with which to replace specified pixels. Can be
either a an RGB triplet or one of the colors listed by
\code{\link[grDevices]{colors}}.}

\item{return.img}{Logical. Should RGB array with swapped colors be returned?}

\item{plotting}{Logical. Should output be plotted in the plot window?}

\item{main}{Optional title to display for image.}
}
\value{
Raster array with indicated pixels changed to target color, if
  \code{return.img = TRUE}.
}
\description{
Changes pixels in an image to a different color and displays and/or returns
the re-colored image.
}
\examples{
# Change a rectangle in the center to black
flowers <- jpeg::readJPEG(system.file("extdata", "flowers.jpg", package =
"countcolors"))

sinister.object <- expand.grid(c(114:314), c(170:470))

countcolors::changePixelColor(flowers, sinister.object, target.color = "black")

\dontrun{
# Change all the white flowers to magenta
indicator.img <- countcolors::sphericalRange(flowers, center = c(1, 1, 1),
radius = 0.1, color.pixels = TRUE, plotting = FALSE)

countcolors::changePixelColor(flowers, indicator.img$pixel.idx,
target.color="magenta")
}
}
