% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_countries.R
\name{random_countries}
\alias{random_countries}
\title{Output random country names}
\usage{
random_countries(n, replace = FALSE, nomenclature = "name_en", seed = NULL)
}
\arguments{
\item{n}{Number of desired (pseudo)random country names.}

\item{replace}{Logical value indicating whether sampling should be with replacement.}

\item{nomenclature}{Nomenclature from which the list of countries should be taken. Not all countries are present in all nomenclature, for example Taiwan is not recognised by the UN, so it will not be returned with \code{"WTO_en"}. The function accept any of the nomenclatures of country_name. For a list of accepted values, refer to \href{https://fbellelli.github.io/countries/articles/dealing_with_names.html}{this page}. The default is \code{name_en}, which is the English list of names in the ISO standard 3166.}

\item{seed}{Single numerical value to be used as seed.}
}
\value{
A vector of n (pseudo)random country names.
}
\description{
This function returns the mode of vectors. That is to say, for any given vector of values, it returns the value that appears most frequently.
The function works with strings, numerical and mixed inputs. \code{NA} values are treated as distinct values.
}
\examples{
random_countries(10)
random_countries(n = 500, replace = TRUE)
random_countries(n = 5, nomenclature = "ISO3", seed = 5)
}
\seealso{
\link[countries]{list_countries}, \link[countries]{country_name}
}
