% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flood_val.R
\name{find_q2}
\alias{find_q2}
\title{Get median flood for each gage}
\usage{
find_q2(site_no)
}
\arguments{
\item{site_no}{Character vector with USGS gage IDs of stream gage sites to
pull.}
}
\value{
A data frame with median flood values (Q2) and the number of years of
  data used to compute this value.
}
\description{
This function will get annual maximum flow series for each USGS gage and
compute median flood (Q2) to serve as flood threshold. Peak flow data
is obtained using the \code{readNWISpeak} function from the
\code{dataRetrieval} package.
}
\examples{
\dontrun{
miami_gages <- gage_extract("12086", start_date = "2000-01-01",
                            end_date = "2009-12-31")
miami_q2 <- find_q2(site_no = miami_gages$site_no)

va_counties <- get_county_cd("Virginia")
va_gages <- get_gages(va_counties, start_date = "2015-01-01", end_date = "2015-12-31")
va_q2 <- find_q2(va_gages$site_no)
}
}
\seealso{
\code{\link[dataRetrieval]{readNWISpeak}}
}
