% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flood_val.R
\name{find_nws}
\alias{find_nws}
\title{Get National Weather Service (NWS) flood stage/discharge levels for gages.}
\usage{
find_nws(site_no, type = "flood")
}
\arguments{
\item{site_no}{Character vector with USGS gage IDs of stream gage sites to
pull.}

\item{type}{Character string with the type of flood stage to be used. Can be
one of four options: "action", "flood", "moderate", and "major". Defaults
to "flood".}
}
\value{
Data frame of gage IDs and the corresponding NWS flood value, if
available.
}
\description{
Use National Weather Service designated flood stages/discharges as flood
thresholds. These come in four levels: "action", "flood", "moderate", and
"major".
}
\note{
Since most USGS gages do not have these values specified (or may
not have all levels), using this definition of the flood threshold can
severely limit the sample size of the data output.
}
\examples{

va_counties <- get_county_cd("Virginia")
va_gages <- get_gages(va_counties, start_date = "2015-01-01",
                      end_date = "2015-12-31")
va_nws <- find_nws(site_no = va_gages$site_no, type = "moderate")

}
