% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid19_anal.R
\name{tots.per.location}
\alias{tots.per.location}
\title{function to compute totals per location}
\usage{
tots.per.location(
  data,
  geo.loc = NULL,
  confBnd = FALSE,
  nbr.plts = 1,
  info = ""
)
}
\arguments{
\item{data}{data.frame with *time series* data from covid19}

\item{geo.loc}{list of locations}

\item{confBnd}{flag to activate/deactivate drawing of confidence bands base on a moving average window}

\item{nbr.plts}{parameter to control the number of plots to display per figure}

\item{info}{additional info to display in plots' titles}
}
\value{
a list or dataframe with totals per specified locations and type of case
}
\description{
function to compute totals per location
}
\examples{

# read data for confirmed cases
data <- covid19.data("ts-confirmed")
# compute totals per location for all the countries
\donttest{
tots.per.location(data)
}
# compute totals per location for 'Italy'
tots.per.location(data,geo.loc="Italy")
# compute totals per location for 'Italy' and 'Germany'
tots.per.location(data,geo.loc=c("Italy","Germany"))

}
