% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_geo}
\alias{add_geo}
\title{Adding the geometry to the downloaded data for drawing maps}
\source{
\itemize{
    \item World map: \url{https://CRAN.R-project.org/package=rnaturalearthdata}
    \item Shapefiles for Brazilian maps: \url{https://www.ibge.gov.br/geociencias/downloads-geociencias.html}
    \item Brazilian DHI data: \url{https://www.ipea.gov.br/ipeageo/bases.html}
  }
}
\usage{
add_geo(data, ...)
}
\arguments{
\item{data}{a data set downloaded using the covid19br::downloadCovid19() function.}

\item{...}{further arguments passed to other methods.}
}
\value{
the data set with the added georeferenced data.
}
\description{
This function adds the necessary geometry for drawing maps to a given data set downloaded by the covid19br::downloadCovid19() function.
}
\details{
The function add_geo() was designed to work with the original names of the variables available in the dataset downloaded by the covid19br::downloadCovid19(). For this reason, this function must be used before any changes in the original names of the variables.

The development human index (DHI) variables (see full description below) are available at city level, and their average are computed for state and region levels.

Data dictionary (Brazilian data):
\itemize{
  \item region: regions' names
  \item state: states' names.
  \item city: cities' names.
  \item DHI: development human index.
  \item EDHI: educational development human index.
  \item LDHI: longevity development human index.
  \item IDHI: income development human index.
  \item pop: estimated population in 2019.
  \item region_code: numerical code attributed to regions
  \item state_code: numerical code attributed to states
  \item mesoregion_code: numerical code attributed to mesoregions
  \item microregion_code: numerical code attributed to microregions
  \item city_code: numerical code attributed to cities
  \item geometry: georeferenced data needed to plot maps.
  \item area: area (in Km^2)
  \item demoDens: demographic density.
}

Data dictionary (world data):
\itemize{
  \item country: country's name
  \item continent: continent's name
  \item region: regions' names
  \item subregion: subregion's name
  \item pop: estimated population
  \item pais: country's name in Portuguese
  \item country_code: numerical code attributed to countries
  \item continent_code: numerical code attributed to continents
  \item region_code: numerical code attributed to regions
  \item subregion_code: numerical code attributed to subregions
  \item geometry: georeferenced data needed to plot maps.
}
}
\examples{
\donttest{
library(covid19br)
library(dplyr)

regions <- downloadCovid19(level = "regions")
regions_geo <- add_geo(regions)
glimpse(regions_geo)
}

}
\author{
Fabio N. Demarqui \email{fndemarqui@est.ufmg.br}
}
