% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covidcast.R
\name{as.covidcast_signal}
\alias{as.covidcast_signal}
\alias{as.covidcast_signal.covidcast_signal}
\alias{as.covidcast_signal.data.frame}
\title{Convert data from an external source into a form compatible with
\code{covidcast_signal}.}
\usage{
as.covidcast_signal(x, ...)

\method{as.covidcast_signal}{covidcast_signal}(x, ...)

\method{as.covidcast_signal}{data.frame}(
  x,
  signal = NULL,
  geo_type = c("county", "msa", "hrr", "dma", "state", "hhs", "nation"),
  time_type = c("day", "week"),
  data_source = "user",
  issue = NULL,
  metadata = list(),
  ...
)
}
\arguments{
\item{x}{Object to be converted. See Methods section below for details on
formatting of each input type.}

\item{...}{Additional arguments passed to methods.}

\item{signal}{The signal name to use for this data.}

\item{geo_type}{The geography type stored in this object.}

\item{time_type}{The time resolution stored in this object. If "day", the
default, each observation covers one day. If "week", each time value is
assumed to be the start date of the epiweek (MMWR week) that the data
represents.}

\item{data_source}{The name of the data source to use as a label for this
data.}

\item{issue}{Issue date to use for this data, if not present in \code{x}, as a
\code{Date} object. If no issue date is present in \code{x} and \code{issue} is \code{NULL},
today's date will be used.}

\item{metadata}{List of metadata to attach to the \code{covidcast_signal} object.
See the "Metadata" section of \code{covidcast_signal()}. All objects will have
\code{geo_type}, \code{data_source}, and \code{signal} columns included in their metadata;
named entries in this list are added as additional columns.}
}
\value{
\code{covidcast_signal} object; see \code{covidcast_signal()} for documentation
of fields and structure.
}
\description{
Several methods are provided to convert common objects (such as data frames)
into \code{covidcast_signal} objects, which can be used with the various
\code{covidcast_signal} methods (such as \code{plot.covidcast_signal()} or
\code{covidcast_cor()}). See \code{vignette("external-data")} for examples.
}
\section{Methods (by class)}{
\itemize{
\item \code{covidcast_signal}: Simply returns the \code{covidcast_signal} object
unchanged.

\item \code{data.frame}: The input data frame \code{x} must contain the
columns \code{time_value}, \code{value}, and \code{geo_value}. If an \code{issue} column is
present in \code{x}, it will be used as the issue date for each observation; if
not, the \code{issue} argument will be used. Other columns will be preserved
as-is.
}}

\seealso{
\code{\link[=covidcast_signal]{covidcast_signal()}}
}
