% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{abbr_to_fips}
\alias{abbr_to_fips}
\title{Get FIPS codes from state abbreviations}
\usage{
abbr_to_fips(
  abbr,
  ignore.case = TRUE,
  perl = FALSE,
  fixed = FALSE,
  ties_method = c("first", "all")
)
}
\arguments{
\item{abbr}{Vector of state abbreviations to look up.}

\item{ignore.case, perl, fixed}{Arguments to pass to \code{grep()}, with the same
defaults as in the latter function, except for \code{ignore.case = TRUE}. Hence,
by default, regular expressions are used; to match against a fixed string
(no regular expressions), set \code{fixed = TRUE}.}

\item{ties_method}{If "first", then only the first match for each name is
returned. If "all", then all matches for each name are returned.}
}
\value{
A vector of FIPS codes if \code{ties_method} equals "first", and a list of
FIPS codes otherwise. These FIPS codes have five digits (ending in "000").
}
\description{
Look up FIPS codes by state abbreviations (including District of Columbia and
Puerto Rico); this function is based on \code{grep()}, and hence allows for
regular expressions.
}
\examples{
abbr_to_fips("PA")
abbr_to_fips(c("PA", "PR", "DC"))

# Note that name_to_fips() works for state names too:
name_to_fips("^Pennsylvania$")

}
\seealso{
\code{\link[=abbr_to_name]{abbr_to_name()}}
}
