% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.coxedExpdur.R
\name{summary.coxedExpdur}
\alias{summary.coxedExpdur}
\title{The mean or median expected duration}
\usage{
\method{summary}{coxedExpdur}(object, stat = "mean", ...)
}
\arguments{
\item{object}{The output from \code{\link[coxed]{coxed}}. If \code{newdata2=NULL}, so that
\code{coxed} is being used to predict duration instead of to calculate a marginal
effect, then the class of the \code{coxed} output will be "\code{coxedExpdur}" and
this function will be called by the generic \code{summary} function}

\item{stat}{Either \code{"mean"} or \code{"median"}}

\item{...}{For future methods}
}
\value{
A scalar containing the mean or median duration, or a vector that also includes
the bootstrapped standard error and confidence interval for this quantity.
}
\description{
This function takes the output of \code{\link[coxed]{coxed}} and calculates the
mean or median of the expected durations across the observations for which durations
are estimated.
}
\details{
If \code{bootstrap=TRUE} in the call to \code{coxed} then a bootstrapped standard error
and confidence interval is reported for the given statistic as well.
}
\examples{
require(survival)
mv.surv <- Surv(martinvanberg$formdur, event = rep(1, nrow(martinvanberg)))
mv.cox <- coxph(mv.surv ~ postel + prevdef + cont + ident + rgovm + pgovno + tpgovno +
     minority, method = "breslow", data = martinvanberg)
summary(mv.cox)

# NPSF method
ed1 <- coxed(mv.cox, method="npsf")
ed1$baseline.functions
ed1$exp.dur
summary(ed1, stat="mean")
summary(ed1, stat="median")

ed1 <- coxed(mv.cox, method="npsf", bootstrap = TRUE)
ed1$exp.dur
summary(ed1, stat="mean")
summary(ed1, stat="median")
}
\author{
Jonathan Kropko <jkropko@virginia.edu> and Jeffrey J. Harden <jharden2@nd.edu>
}
