% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aut(multi).R
\name{multiple.mrc}
\alias{multiple.mrc}
\title{Most recent changepoints from mrc method using censored AR/MA timeseries.}
\usage{
multiple.mrc(mrc, pmax = 10, alpha = 2, elbow.thresh = 0.5,
  n = 500)
}
\arguments{
\item{mrc}{data obtained from mrc.mean}

\item{pmax}{Maximum number of most recent changepoints
to search for. Default value pmax=10.}

\item{alpha}{The variable specific penalty used to penalise
the addition of a given changepoint into a given variable. Default
value alpha = 2.}

\item{elbow.thresh}{default 0.5.}

\item{n}{length of series}
}
\value{
indicates the most recent changepoint in each series .
}
\description{
Detecting most recent changepoints from mrc method consisting
of many related univariate timeseries (Bardwell, Eckley, Fearnhead, and Smith, 2016)
after generating censored data from AR/MA model
and pools information across the time-series by
solving the K-median problem using tb.raw (Teitz and Bart, 1968).
}
\examples{
#'#example(left censoring)
library(cpcens)
n=300
N=100
# Generate censored data using MA model
sim=MA1.data(n = 300, N = 100, K = 5, eps = 1,
rho = 0.4, mu = 0, siga = 1, rates = c(0.6,NA), Mrate = 0)
data=sim$data
mrc = mrc.mean( data , beta = 1.5*log(n) )
c = multiple.mrc(  mrc , pmax=10, alpha = 2 , elbow.thresh = 0.5, n=500 )
p.hat = c$MDL
mrc.chpts = c$locs[[p.hat]][ c$affected[[p.hat]] ]
mrc.chpts
}
\references{
Teitz, M. B. and Bart, P. (1968). Heuristic methods for estimating the generalized vertex
median of a weighted graph. Operations Research, 16(5):955–961.

Bardwell, L., Fearnhead, P., Eckley, I. A., Smith, S., and Spott, M. (2019). Most recent
changepoint detection in panel data. Technometrics, 61(1):88–98.
}
\seealso{
mrc
}
