\name{getSenseCPLEX}
\alias{getSenseCPLEX}
\alias{CPXgetsense}

\title{
  Access the Sense for a Range of Constraints in a CPLEX Problem Object.
}

\description{
  Low level interface function to the IBM ILOG CPLEX function
  \code{CPXgetsense}.  Consult the IBM ILOG CPLEX documentation for more
  detailed information.
}

\usage{
  getSenseCPLEX(env, lp, begin, end)
}

\arguments{
  \item{env}{
    An object of class \code{"\linkS4class{cplexPtr}"} as returned by
    \code{\link{openEnvCPLEX}}. This is basically a pointer to an
    IBM ILOG CPLEX environment.
  }
  \item{lp}{
    An object of class \code{"\linkS4class{cplexPtr}"} as returned by
    \code{\link{initProbCPLEX}}. This is basically a pointer to an
    IBM ILOG CPLEX problem object.
  }
  \item{begin}{
	An integer specifying the beginning of the range of constraint
	senses to be returned.
  }
  \item{end}{
	An integer specifying the end of the range of constraint
	senses to be returned.
  }
}

\details{
  Interface to the C function \code{getSense} which calls the CPLEX
  function \code{CPXgetsense}.
}

\value{
  Specified constraint senses if successful, otherwise an instance of class
  \code{"\linkS4class{cplexError}"}.
}

\references{
  The IBM ILOG CPLEX home page at
  \url{https://www.ibm.com/developerworks/university/academicinitiative/}.
}

\author{
  Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>

  Maintainer: Claus Jonathan Fritzemeier <clausjonathan.fritzemeier@uni-duesseldorf.de>
}


\keyword{ optimize }
