% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\docType{methods}
\name{show}
\alias{show}
\alias{show,cpop.class-method}
\title{Display the S4 object produced by cpop}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{cpop}}.}
}
\description{
Displays an S4 object produced by \code{\link{cpop}}.
}
\examples{
library(cpop)

# simulate data with change in gradient
set.seed(1)
x <- (1:50/5)^2
y <- simchangeslope(x,changepoints=c(10,50),change.slope=c(0.25,-0.25),sd=1)

# determine changepoints
res <- cpop(y,x,beta=2*log(length(y)))

# display a summary of the results using show
show(res)

}
\references{
\insertRef{cpop-jss-article-2024}{cpop}
}
