#' Convert cppRouting graph to data.frame
#' 
#' @param Graph  An object generated by cppRouting::makegraph() or cpp_simplify() function.
#' @return Data.frame with from, to and dist column
#' @examples
#' #Simple directed graph
#' 
#' edges<-data.frame(from=c(1,2,3,4,5,6,7,8),
#' to=c(0,1,2,3,6,7,8,5),
#' dist=c(1,1,1,1,1,1,1,1))
#' 
#' #Construct cppRouting graph
#' graph<-makegraph(edges,directed=TRUE)
#' 
#' #Convert cppRouting graph to data.frame
#' 
#' df<-to_df(graph)


to_df<-function(Graph){
  dat<-Graph$data
  dat$from<-Graph$dict$ref[match(dat$from,Graph$dict$id)]
  dat$to<-Graph$dict$ref[match(dat$to,Graph$dict$id)]
  return(dat)
}


